/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.rendering;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;

public final class TessellationManager {
    public static final double pixel = 0.0625;
    private static final Tessellator tr = Tessellator.field_78398_a;
    private static double xBaseCoord = 0.0;
    private static double yBaseCoord = 0.0;
    private static double zBaseCoord = 0.0;

    private TessellationManager() {
    }

    public static final void setBaseCoords(double ... coords) {
        if (coords != null && coords.length >= 3) {
            xBaseCoord = coords[0];
            yBaseCoord = coords[1];
            zBaseCoord = coords[2];
        }
    }

    public static final void resetBaseCoords() {
        xBaseCoord = 0.0;
        yBaseCoord = 0.0;
        zBaseCoord = 0.0;
    }

    public static final void renderCube(double xOffset, double yOffset, double zOffset, double width, double height, double depth, IIcon icon) {
        TessellationManager.renderCube(xOffset, yOffset, zOffset, width, height, depth, icon, false, 0.0625);
    }

    public static final void renderCube(double xOffset, double yOffset, double zOffset, double width, double height, double depth, IIcon icon, boolean renderInside, double scale) {
        TessellationManager.renderPositiveXFace(xOffset + width, yOffset, zOffset, height, depth, icon, scale);
        TessellationManager.renderNegativeXFace(xOffset, yOffset, zOffset, height, depth, icon, scale);
        TessellationManager.renderPositiveYFace(xOffset, yOffset + height, zOffset, width, depth, icon, scale);
        TessellationManager.renderNegativeYFace(xOffset, yOffset, zOffset, width, depth, icon, scale);
        TessellationManager.renderPositiveZFace(xOffset, yOffset, zOffset + depth, width, height, icon, scale);
        TessellationManager.renderNegativeZFace(xOffset, yOffset, zOffset, width, height, icon, scale);
        if (renderInside) {
            TessellationManager.renderNegativeXFace(xOffset + width, yOffset, zOffset, height, depth, icon, scale);
            TessellationManager.renderPositiveXFace(xOffset, yOffset, zOffset, height, depth, icon, scale);
            TessellationManager.renderNegativeYFace(xOffset, yOffset + height, zOffset, width, depth, icon, scale);
            TessellationManager.renderPositiveYFace(xOffset, yOffset, zOffset, width, depth, icon, scale);
            TessellationManager.renderNegativeZFace(xOffset, yOffset, zOffset + depth, width, height, icon, scale);
            TessellationManager.renderPositiveZFace(xOffset, yOffset, zOffset, width, height, icon, scale);
        }
    }

    public static final void renderPositiveXFace(double xOffset, double yOffset, double zOffset, double height, double depth, IIcon icon) {
        TessellationManager.renderPositiveXFace(xOffset, yOffset, zOffset, height, depth, 0.0, 0.0, 0.0, 0.0, icon, 0.0625);
    }

    public static final void renderPositiveXFace(double xOffset, double yOffset, double zOffset, double height, double depth, IIcon icon, double scale) {
        TessellationManager.renderPositiveXFace(xOffset, yOffset, zOffset, height, depth, 0.0, 0.0, 0.0, 0.0, icon, scale);
    }

    public static final void renderPositiveXFace(double xOffset, double yOffset, double zOffset, double height, double depth, double uOffset, double vOffset, double uMaxOffset, double vMaxOffset, IIcon icon, double scale) {
        tr.func_78375_b(1.0f, 0.0f, 0.0f);
        double x = xBaseCoord + xOffset * scale;
        double zBr = zBaseCoord + zOffset * scale;
        double yBr = yBaseCoord + yOffset * scale;
        double zTr = zBaseCoord + zOffset * scale;
        double yTr = yBaseCoord + (yOffset + height) * scale;
        double zTl = zBaseCoord + (zOffset + depth) * scale;
        double yTl = yBaseCoord + (yOffset + height) * scale;
        double zBl = zBaseCoord + (zOffset + depth) * scale;
        double yBl = yBaseCoord + yOffset * scale;
        double minU = uOffset > 0.0 && uOffset < 16.0 ? (double)(icon.func_94209_e() + (icon.func_94214_a(uOffset) - icon.func_94209_e())) : (double)icon.func_94209_e();
        double maxU = uMaxOffset > 0.0 && uMaxOffset < 16.0 ? (double)(icon.func_94212_f() - (icon.func_94212_f() - icon.func_94214_a(uMaxOffset))) : (double)icon.func_94212_f();
        double minV = vOffset > 0.0 && vOffset < 16.0 ? (double)(icon.func_94206_g() + (icon.func_94207_b(vOffset) - icon.func_94206_g())) : (double)icon.func_94206_g();
        double maxV = vMaxOffset > 0.0 && vMaxOffset < 16.0 ? (double)(icon.func_94210_h() - (icon.func_94210_h() - icon.func_94207_b(vMaxOffset))) : (double)icon.func_94210_h();
        tr.func_78374_a(x, yBr, zBr, maxU, maxV);
        tr.func_78374_a(x, yTr, zTr, maxU, minV);
        tr.func_78374_a(x, yTl, zTl, minU, minV);
        tr.func_78374_a(x, yBl, zBl, minU, maxV);
    }

    public static final void renderNegativeXFace(double xOffset, double yOffset, double zOffset, double height, double depth, IIcon icon) {
        TessellationManager.renderNegativeXFace(xOffset, yOffset, zOffset, height, depth, 0.0, 0.0, 0.0, 0.0, icon, 0.0625);
    }

    public static final void renderNegativeXFace(double xOffset, double yOffset, double zOffset, double height, double depth, IIcon icon, double scale) {
        TessellationManager.renderNegativeXFace(xOffset, yOffset, zOffset, height, depth, 0.0, 0.0, 0.0, 0.0, icon, scale);
    }

    public static final void renderNegativeXFace(double xOffset, double yOffset, double zOffset, double height, double depth, double uOffset, double vOffset, double uMaxOffset, double vMaxOffset, IIcon icon, double scale) {
        tr.func_78375_b(-1.0f, 0.0f, 0.0f);
        double x = xBaseCoord + xOffset * scale;
        double zBl = zBaseCoord + zOffset * scale;
        double yBl = yBaseCoord + yOffset * scale;
        double zBr = zBaseCoord + (zOffset + depth) * scale;
        double yBr = yBaseCoord + yOffset * scale;
        double zTr = zBaseCoord + (zOffset + depth) * scale;
        double yTr = yBaseCoord + (yOffset + height) * scale;
        double zTl = zBaseCoord + zOffset * scale;
        double yTl = yBaseCoord + (yOffset + height) * scale;
        double minU = uOffset > 0.0 && uOffset < 16.0 ? (double)(icon.func_94209_e() + (icon.func_94214_a(uOffset) - icon.func_94209_e())) : (double)icon.func_94209_e();
        double maxU = uMaxOffset > 0.0 && uMaxOffset < 16.0 ? (double)(icon.func_94212_f() - (icon.func_94212_f() - icon.func_94214_a(uMaxOffset))) : (double)icon.func_94212_f();
        double minV = vOffset > 0.0 && vOffset < 16.0 ? (double)(icon.func_94206_g() + (icon.func_94207_b(vOffset) - icon.func_94206_g())) : (double)icon.func_94206_g();
        double maxV = vMaxOffset > 0.0 && vMaxOffset < 16.0 ? (double)(icon.func_94210_h() - (icon.func_94210_h() - icon.func_94207_b(vMaxOffset))) : (double)icon.func_94210_h();
        tr.func_78374_a(x, yBl, zBl, minU, maxV);
        tr.func_78374_a(x, yBr, zBr, maxU, maxV);
        tr.func_78374_a(x, yTr, zTr, maxU, minV);
        tr.func_78374_a(x, yTl, zTl, minU, minV);
    }

    public static final void renderPositiveYFace(double xOffset, double yOffset, double zOffset, double width, double depth, IIcon icon) {
        TessellationManager.renderPositiveYFace(xOffset, yOffset, zOffset, width, depth, 0.0, 0.0, 0.0, 0.0, icon, 0.0625);
    }

    public static final void renderPositiveYFace(double xOffset, double yOffset, double zOffset, double width, double depth, IIcon icon, double scale) {
        TessellationManager.renderPositiveYFace(xOffset, yOffset, zOffset, width, depth, 0.0, 0.0, 0.0, 0.0, icon, scale);
    }

    public static final void renderPositiveYFace(double xOffset, double yOffset, double zOffset, double width, double depth, double uOffset, double vOffset, double uMaxOffset, double vMaxOffset, IIcon icon, double scale) {
        tr.func_78375_b(0.0f, 1.0f, 0.0f);
        double y = yBaseCoord + yOffset * scale;
        double xBr = xBaseCoord + xOffset * scale;
        double zBr = zBaseCoord + zOffset * scale;
        double xTr = xBaseCoord + xOffset * scale;
        double zTr = zBaseCoord + (zOffset + depth) * scale;
        double xTl = xBaseCoord + (xOffset + width) * scale;
        double zTl = zBaseCoord + (zOffset + depth) * scale;
        double xBl = xBaseCoord + (xOffset + width) * scale;
        double zBl = zBaseCoord + zOffset * scale;
        double minU = uOffset > 0.0 && uOffset < 16.0 ? (double)(icon.func_94209_e() + (icon.func_94214_a(uOffset) - icon.func_94209_e())) : (double)icon.func_94209_e();
        double maxU = uMaxOffset > 0.0 && uMaxOffset < 16.0 ? (double)(icon.func_94212_f() - (icon.func_94212_f() - icon.func_94214_a(uMaxOffset))) : (double)icon.func_94212_f();
        double minV = vOffset > 0.0 && vOffset < 16.0 ? (double)(icon.func_94206_g() + (icon.func_94207_b(vOffset) - icon.func_94206_g())) : (double)icon.func_94206_g();
        double maxV = vMaxOffset > 0.0 && vMaxOffset < 16.0 ? (double)(icon.func_94210_h() - (icon.func_94210_h() - icon.func_94207_b(vMaxOffset))) : (double)icon.func_94210_h();
        tr.func_78374_a(xBr, y, zBr, maxU, maxV);
        tr.func_78374_a(xTr, y, zTr, maxU, minV);
        tr.func_78374_a(xTl, y, zTl, minU, minV);
        tr.func_78374_a(xBl, y, zBl, minU, maxV);
    }

    public static final void renderNegativeYFace(double xOffset, double yOffset, double zOffset, double width, double depth, IIcon icon) {
        TessellationManager.renderNegativeYFace(xOffset, yOffset, zOffset, width, depth, 0.0, 0.0, 0.0, 0.0, icon, 0.0625);
    }

    public static final void renderNegativeYFace(double xOffset, double yOffset, double zOffset, double width, double depth, IIcon icon, double scale) {
        TessellationManager.renderNegativeYFace(xOffset, yOffset, zOffset, width, depth, 0.0, 0.0, 0.0, 0.0, icon, scale);
    }

    public static final void renderNegativeYFace(double xOffset, double yOffset, double zOffset, double width, double depth, double uOffset, double vOffset, double uMaxOffset, double vMaxOffset, IIcon icon, double scale) {
        tr.func_78375_b(0.0f, -1.0f, 0.0f);
        double y = yBaseCoord + yOffset * scale;
        double xTr = xBaseCoord + xOffset * scale;
        double zTr = zBaseCoord + zOffset * scale;
        double xTl = xBaseCoord + (xOffset + width) * scale;
        double zTl = zBaseCoord + zOffset * scale;
        double xBl = xBaseCoord + (xOffset + width) * scale;
        double zBl = zBaseCoord + (zOffset + depth) * scale;
        double xBr = xBaseCoord + xOffset * scale;
        double zBr = zBaseCoord + (zOffset + depth) * scale;
        double minU = uOffset > 0.0 && uOffset < 16.0 ? (double)(icon.func_94209_e() + (icon.func_94214_a(uOffset) - icon.func_94209_e())) : (double)icon.func_94209_e();
        double maxU = uMaxOffset > 0.0 && uMaxOffset < 16.0 ? (double)(icon.func_94212_f() - (icon.func_94212_f() - icon.func_94214_a(uMaxOffset))) : (double)icon.func_94212_f();
        double minV = vOffset > 0.0 && vOffset < 16.0 ? (double)(icon.func_94206_g() + (icon.func_94207_b(vOffset) - icon.func_94206_g())) : (double)icon.func_94206_g();
        double maxV = vMaxOffset > 0.0 && vMaxOffset < 16.0 ? (double)(icon.func_94210_h() - (icon.func_94210_h() - icon.func_94207_b(vMaxOffset))) : (double)icon.func_94210_h();
        tr.func_78374_a(xTr, y, zTr, maxU, minV);
        tr.func_78374_a(xTl, y, zTl, minU, minV);
        tr.func_78374_a(xBl, y, zBl, minU, maxV);
        tr.func_78374_a(xBr, y, zBr, maxU, maxV);
    }

    public static final void renderPositiveZFace(double xOffset, double yOffset, double zOffset, double width, double height, IIcon icon) {
        TessellationManager.renderPositiveZFace(xOffset, yOffset, zOffset, width, height, 0.0, 0.0, 0.0, 0.0, icon, 0.0625);
    }

    public static final void renderPositiveZFace(double xOffset, double yOffset, double zOffset, double width, double height, IIcon icon, double scale) {
        TessellationManager.renderPositiveZFace(xOffset, yOffset, zOffset, width, height, 0.0, 0.0, 0.0, 0.0, icon, scale);
    }

    public static final void renderPositiveZFace(double xOffset, double yOffset, double zOffset, double width, double height, double uOffset, double vOffset, double uMaxOffset, double vMaxOffset, IIcon icon, double scale) {
        tr.func_78375_b(0.0f, 0.0f, 1.0f);
        double z = zBaseCoord + zOffset * scale;
        double xBl = xBaseCoord + xOffset * scale;
        double yBl = yBaseCoord + yOffset * scale;
        double xBr = xBaseCoord + (xOffset + width) * scale;
        double yBr = yBaseCoord + yOffset * scale;
        double xTr = xBaseCoord + (xOffset + width) * scale;
        double yTr = yBaseCoord + (yOffset + height) * scale;
        double xTl = xBaseCoord + xOffset * scale;
        double yTl = yBaseCoord + (yOffset + height) * scale;
        double minU = uOffset > 0.0 && uOffset < 16.0 ? (double)(icon.func_94209_e() + (icon.func_94214_a(uOffset) - icon.func_94209_e())) : (double)icon.func_94209_e();
        double maxU = uMaxOffset > 0.0 && uMaxOffset < 16.0 ? (double)(icon.func_94212_f() - (icon.func_94212_f() - icon.func_94214_a(uMaxOffset))) : (double)icon.func_94212_f();
        double minV = vOffset > 0.0 && vOffset < 16.0 ? (double)(icon.func_94206_g() + (icon.func_94207_b(vOffset) - icon.func_94206_g())) : (double)icon.func_94206_g();
        double maxV = vMaxOffset > 0.0 && vMaxOffset < 16.0 ? (double)(icon.func_94210_h() - (icon.func_94210_h() - icon.func_94207_b(vMaxOffset))) : (double)icon.func_94210_h();
        tr.func_78374_a(xBl, yBl, z, minU, maxV);
        tr.func_78374_a(xBr, yBr, z, maxU, maxV);
        tr.func_78374_a(xTr, yTr, z, maxU, minV);
        tr.func_78374_a(xTl, yTl, z, minU, minV);
    }

    public static final void renderNegativeZFace(double xOffset, double yOffset, double zOffset, double width, double height, IIcon icon) {
        TessellationManager.renderNegativeZFace(xOffset, yOffset, zOffset, width, height, 0.0, 0.0, 0.0, 0.0, icon, 0.0625);
    }

    public static final void renderNegativeZFace(double xOffset, double yOffset, double zOffset, double width, double height, IIcon icon, double scale) {
        TessellationManager.renderNegativeZFace(xOffset, yOffset, zOffset, width, height, 0.0, 0.0, 0.0, 0.0, icon, scale);
    }

    public static final void renderNegativeZFace(double xOffset, double yOffset, double zOffset, double width, double height, double uOffset, double vOffset, double uMaxOffset, double vMaxOffset, IIcon icon, double scale) {
        tr.func_78375_b(0.0f, 0.0f, -1.0f);
        double z = zBaseCoord + zOffset * scale;
        double xBr = xBaseCoord + xOffset * scale;
        double yBr = yBaseCoord + yOffset * scale;
        double xTr = xBaseCoord + xOffset * scale;
        double yTr = yBaseCoord + (yOffset + height) * scale;
        double xTl = xBaseCoord + (xOffset + width) * scale;
        double yTl = yBaseCoord + (yOffset + height) * scale;
        double xBl = xBaseCoord + (xOffset + width) * scale;
        double yBl = yBaseCoord + yOffset * scale;
        double minU = uOffset > 0.0 && uOffset < 16.0 ? (double)(icon.func_94209_e() + (icon.func_94214_a(uOffset) - icon.func_94209_e())) : (double)icon.func_94209_e();
        double maxU = uMaxOffset > 0.0 && uMaxOffset < 16.0 ? (double)(icon.func_94212_f() - (icon.func_94212_f() - icon.func_94214_a(uMaxOffset))) : (double)icon.func_94212_f();
        double minV = vOffset > 0.0 && vOffset < 16.0 ? (double)(icon.func_94206_g() + (icon.func_94207_b(vOffset) - icon.func_94206_g())) : (double)icon.func_94206_g();
        double maxV = vMaxOffset > 0.0 && vMaxOffset < 16.0 ? (double)(icon.func_94210_h() - (icon.func_94210_h() - icon.func_94207_b(vMaxOffset))) : (double)icon.func_94210_h();
        tr.func_78374_a(xBr, yBr, z, maxU, maxV);
        tr.func_78374_a(xTr, yTr, z, maxU, minV);
        tr.func_78374_a(xTl, yTl, z, minU, minV);
        tr.func_78374_a(xBl, yBl, z, minU, maxV);
    }

    public static final void startDrawingQuads() {
        tr.func_78382_b();
    }

    public static final void draw() {
        tr.func_78381_a();
    }

    public static final void setBrightness(int brightness) {
        tr.func_78380_c(brightness);
    }

    public static final void setColorOpaque(float r, float g, float b) {
        tr.func_78386_a(r, g, b);
    }
}

