/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.tileentities;

import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.zarathul.simplefluidtanks.common.BlockCoords;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.rendering.ConnectedTexturesHelper;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public class TankBlockEntity
extends TileEntity {
    private int fillPercentage = 0;
    private boolean isPartOfTank = false;
    private BlockCoords valveCoords = null;
    private int[] textureIds = new int[]{0, 0, 0, 0, 0, 0};
    private boolean[] connections = new boolean[6];

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.fillPercentage = tag.func_74771_c("FillPercentage");
        this.isPartOfTank = tag.func_74767_n("isPartOfTank");
        if (this.isPartOfTank) {
            int[] valveCoordsArray = tag.func_74759_k("ValveCoords");
            this.valveCoords = new BlockCoords(valveCoordsArray[0], valveCoordsArray[1], valveCoordsArray[2]);
        }
        this.textureIds = tag.func_74759_k("TextureIds");
        this.connections = new boolean[6];
        this.connections[5] = tag.func_74767_n("X+");
        this.connections[4] = tag.func_74767_n("X-");
        this.connections[1] = tag.func_74767_n("Y+");
        this.connections[0] = tag.func_74767_n("Y-");
        this.connections[3] = tag.func_74767_n("Z+");
        this.connections[2] = tag.func_74767_n("Z-");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("FillPercentage", (byte)this.fillPercentage);
        tag.func_74757_a("isPartOfTank", this.isPartOfTank);
        if (this.valveCoords != null) {
            int[] valveCoordsArray = new int[]{this.valveCoords.x, this.valveCoords.y, this.valveCoords.z};
            tag.func_74783_a("ValveCoords", valveCoordsArray);
        }
        tag.func_74783_a("TextureIds", this.textureIds);
        tag.func_74757_a("X+", this.connections[5]);
        tag.func_74757_a("X-", this.connections[4]);
        tag.func_74757_a("Y+", this.connections[1]);
        tag.func_74757_a("Y-", this.connections[0]);
        tag.func_74757_a("Z+", this.connections[3]);
        tag.func_74757_a("Z-", this.connections[2]);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean isPartOfTank() {
        return this.isPartOfTank && this.valveCoords != null;
    }

    public boolean isEmpty() {
        return this.fillPercentage == 0;
    }

    public ValveBlockEntity getValve() {
        if (this.isPartOfTank()) {
            return Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, ValveBlockEntity.class, this.valveCoords);
        }
        return null;
    }

    public boolean setValve(BlockCoords coords) {
        if (this.isPartOfTank() || coords == null) {
            return false;
        }
        ValveBlockEntity valveEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, ValveBlockEntity.class, coords);
        if (valveEntity != null) {
            this.valveCoords = coords;
            this.isPartOfTank = true;
            return true;
        }
        return false;
    }

    public void updateTextures() {
        this.updateConnections();
        this.textureIds[5] = ConnectedTexturesHelper.getPositiveXTexture(this.connections);
        this.textureIds[4] = ConnectedTexturesHelper.getNegativeXTexture(this.connections);
        this.textureIds[1] = ConnectedTexturesHelper.getPositiveYTexture(this.connections);
        this.textureIds[0] = ConnectedTexturesHelper.getNegativeYTexture(this.connections);
        this.textureIds[3] = ConnectedTexturesHelper.getPositiveZTexture(this.connections);
        this.textureIds[2] = ConnectedTexturesHelper.getNegativeZTexture(this.connections);
    }

    public int getFillPercentage() {
        return this.fillPercentage;
    }

    public boolean setFillPercentage(int percentage, boolean forceBlockUpdate) {
        boolean percentageChanged = (percentage = MathHelper.func_76125_a((int)percentage, (int)0, (int)100)) != this.fillPercentage;
        this.fillPercentage = percentage;
        if (percentageChanged || forceBlockUpdate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        }
        return percentageChanged;
    }

    public Fluid getFluid() {
        FluidStack fluidStack;
        ValveBlockEntity valve = this.getValve();
        if (valve != null && (fluidStack = valve.getFluid()) != null) {
            return fluidStack.getFluid();
        }
        return null;
    }

    public boolean[] getConnections() {
        return this.connections;
    }

    public int getTextureIndex(int side) {
        if (side < 0 || side > 5) {
            return -1;
        }
        return this.textureIds[side];
    }

    public boolean hasValveAt(BlockCoords coords) {
        if (!this.isPartOfTank() || coords == null) {
            return false;
        }
        return coords.equals(this.valveCoords);
    }

    private void updateConnections() {
        this.connections[5] = this.shouldConnectTo(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        this.connections[4] = this.shouldConnectTo(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        this.connections[1] = this.shouldConnectTo(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        this.connections[0] = this.shouldConnectTo(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        this.connections[3] = this.shouldConnectTo(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        this.connections[2] = this.shouldConnectTo(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
    }

    private boolean shouldConnectTo(int x, int y, int z) {
        if (x < this.field_145851_c - 1 || x > this.field_145851_c + 1 || y < this.field_145848_d - 1 || y > this.field_145848_d + 1 || z < this.field_145849_e - 1 || z > this.field_145849_e + 1) {
            return false;
        }
        TankBlockEntity connectionCandidate = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, x, y, z);
        if (connectionCandidate != null) {
            return connectionCandidate.hasValveAt(this.valveCoords);
        }
        return false;
    }

    public void disconnect(boolean suppressBlockUpdates) {
        this.isPartOfTank = false;
        this.fillPercentage = 0;
        this.valveCoords = null;
        Arrays.fill(this.textureIds, 0);
        Arrays.fill(this.connections, false);
        if (!suppressBlockUpdates) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        }
    }
}

