/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.tileentities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.blocks.FluidTank;
import net.zarathul.simplefluidtanks.blocks.TankBlock;
import net.zarathul.simplefluidtanks.common.BasicAStar;
import net.zarathul.simplefluidtanks.common.BlockCoords;
import net.zarathul.simplefluidtanks.common.BlockSearchMode;
import net.zarathul.simplefluidtanks.common.Direction;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;

public class ValveBlockEntity
extends TileEntity
implements IFluidHandler {
    private final FluidTank internalTank = new FluidTank(0);
    private int linkedTankCount = 0;
    private Multimap<Integer, BlockCoords> tankPriorities = ArrayListMultimap.create();
    private byte tankFacingSides = (byte)-1;
    private HashMap<BlockCoords, Integer> tankToPriorityMappings;
    private HashSet<BlockCoords> tanks;
    private HashSet<BlockCoords> tanksBeforeDisband;
    private BasicAStar aStar;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.internalTank.readFromNBT(tag);
        this.readTankPrioritiesFromNBT(tag);
        this.linkedTankCount = Math.max(this.tankPriorities.size() - 1, 0);
        this.tankFacingSides = tag.func_74771_c("TankFacingSides");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.internalTank.writeToNBT(tag);
        this.writeTankPrioritiesToNBT(tag);
        tag.func_74774_a("TankFacingSides", this.tankFacingSides);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("TankFacingSides", this.tankFacingSides);
        tag.func_74768_a("LinkedTankCount", this.linkedTankCount);
        this.internalTank.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.tankFacingSides = tag.func_74771_c("TankFacingSides");
        this.linkedTankCount = tag.func_74762_e("LinkedTankCount");
        this.internalTank.readFromNBT(tag);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canUpdate() {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack fillFluid, boolean doFill) {
        if (!this.field_145850_b.field_72995_K && this.hasTanks()) {
            int fillAmount = this.internalTank.fill(fillFluid, doFill);
            if (doFill && fillAmount > 0) {
                this.distributeFluidToTanks();
                this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)SimpleFluidTanks.valveBlock);
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(fillFluid, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this.internalTank, fillFluid.amount));
            }
            return fillAmount;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack drainFluid, boolean doDrain) {
        return this.drain(from, drainFluid, -1, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int drainAmount, boolean doDrain) {
        return this.drain(from, null, drainAmount, doDrain);
    }

    private FluidStack drain(ForgeDirection from, FluidStack drainFluid, int drainAmount, boolean doDrain) {
        if (!this.field_145850_b.field_72995_K && this.hasTanks()) {
            FluidStack drainedFluid;
            FluidStack fluidStack = drainFluid != null && drainFluid.isFluidEqual(this.internalTank.getFluid()) ? this.internalTank.drain(drainFluid.amount, doDrain) : (drainedFluid = drainAmount >= 0 ? this.internalTank.drain(drainAmount, doDrain) : null);
            if (doDrain && drainedFluid != null && drainedFluid.amount > 0) {
                this.distributeFluidToTanks();
                this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)SimpleFluidTanks.valveBlock);
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(drainedFluid, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this.internalTank, drainedFluid.amount));
            }
            return drainedFluid;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.hasTanks() && !this.isFacingTank(Direction.fromForge(from)) && fluid != null && !this.internalTank.isFull()) {
            FluidStack tankFluid = this.internalTank.getFluid();
            return tankFluid == null || tankFluid.isFluidEqual(new FluidStack(fluid, 0));
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.hasTanks() && !this.isFacingTank(Direction.fromForge(from)) && fluid != null && this.internalTank.getFluidAmount() > 0) {
            FluidStack tankFluid = this.internalTank.getFluid();
            return tankFluid != null && tankFluid.isFluidEqual(new FluidStack(fluid, 0));
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.internalTank.getInfo()};
    }

    public int getCapacity() {
        return this.internalTank.getCapacity();
    }

    public int getFluidAmount() {
        return this.internalTank.getFluidAmount();
    }

    public int getRemainingCapacity() {
        return this.internalTank.getRemainingCapacity();
    }

    public int getFluidLuminosity() {
        Fluid fluid;
        FluidStack storedFluid = this.internalTank.getFluid();
        if (storedFluid != null && (fluid = storedFluid.getFluid()) != null) {
            return fluid.getLuminosity();
        }
        return 0;
    }

    public String getLocalizedFluidName() {
        Fluid fluid;
        FluidStack storedFluid = this.internalTank.getFluid();
        if (storedFluid != null && (fluid = storedFluid.getFluid()) != null) {
            return fluid.getLocalizedName(storedFluid);
        }
        return null;
    }

    public FluidStack getFluid() {
        return this.internalTank.getFluid();
    }

    public boolean isFull() {
        return this.internalTank.isFull();
    }

    public int getTankFacingSides() {
        return this.tankFacingSides;
    }

    public void updateTankFacingSides() {
        int sides = 0;
        BlockCoords coords = new BlockCoords(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.isInTankList(coords.offset(3))) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get(3)).intValue();
        }
        if (this.isInTankList(coords.offset(2))) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get(2)).intValue();
        }
        if (this.isInTankList(coords.offset(5))) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get(5)).intValue();
        }
        if (this.isInTankList(coords.offset(4))) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get(4)).intValue();
        }
        if (this.isInTankList(coords.offset(1))) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get(1)).intValue();
        }
        if (this.isInTankList(coords.offset(0))) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get(0)).intValue();
        }
        this.tankFacingSides = (byte)sides;
    }

    public boolean isFacingTank(int side) {
        if (side >= -128 && side <= 127) {
            byte flags = (byte)((Integer)Direction.sidesToBitFlagsMappings.get(side)).intValue();
            return (this.tankFacingSides & flags) == flags;
        }
        return false;
    }

    public boolean hasTanks() {
        return this.linkedTankCount > 0;
    }

    public int getLinkedTankCount() {
        return this.linkedTankCount;
    }

    public void disbandMultiblock() {
        this.disbandMultiblock(false);
    }

    public void disbandMultiblock(boolean suppressBlockUpdates) {
        FluidStack fluidInTank;
        for (BlockCoords tankCoords : this.tankPriorities.values()) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tankCoords);
            if (tankEntity == null) continue;
            tankEntity.disconnect(suppressBlockUpdates);
        }
        if (suppressBlockUpdates) {
            this.tanksBeforeDisband = new HashSet();
            this.tanksBeforeDisband.addAll(this.tankPriorities.values());
        }
        FluidStack spilledFluid = (fluidInTank = this.internalTank.getFluid()) != null ? fluidInTank.copy() : null;
        this.tankPriorities.clear();
        this.linkedTankCount = 0;
        this.tankFacingSides = 0;
        this.internalTank.setFluid(null);
        this.internalTank.setCapacity(0);
        if (!suppressBlockUpdates) {
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)SimpleFluidTanks.valveBlock);
            if (spilledFluid != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(spilledFluid, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
        }
    }

    public void formMultiblock() {
        FluidStack fluid = this.internalTank.getFluid();
        int oldFluidAmount = fluid != null ? fluid.amount : 0;
        this.disbandMultiblock(true);
        this.findAndPrioritizeTanks();
        this.updateOrphanedTanks();
        this.updateTankFacingSides();
        this.internalTank.setFluid(fluid);
        this.distributeFluidToTanks(true);
        this.linkedTankCount = Math.max(this.tankPriorities.size() - 1, 0);
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)SimpleFluidTanks.valveBlock);
        if (oldFluidAmount > this.internalTank.getCapacity() && fluid != null) {
            FluidStack spilledFluid = fluid.copy();
            spilledFluid.amount = oldFluidAmount - this.internalTank.getCapacity();
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(spilledFluid, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    private void findAndPrioritizeTanks() {
        this.generateTankList();
        this.computeFillPriorities();
        ArrayList<TankBlockEntity> tankEntities = new ArrayList<TankBlockEntity>(this.tankPriorities.size());
        for (BlockCoords tankCoords : this.tankPriorities.values()) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tankCoords);
            if (tankEntity == null) continue;
            tankEntity.setValve(new BlockCoords(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            tankEntities.add(tankEntity);
        }
        for (TankBlockEntity t : tankEntities) {
            t.updateTextures();
        }
        this.internalTank.setCapacity((tankEntities.size() + 1) * Config.bucketsPerTank * 1000);
    }

    private void updateOrphanedTanks() {
        Collection tanksToUpdate = Collections2.filter(this.tanksBeforeDisband, (Predicate)Predicates.not((Predicate)Predicates.in(this.tanks)));
        for (BlockCoords tank : tanksToUpdate) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tank);
            if (tankEntity == null) continue;
            this.field_145850_b.func_147476_b(tank.x, tank.y, tank.z, (TileEntity)tankEntity);
            this.field_145850_b.func_147471_g(tank.x, tank.y, tank.z);
        }
        this.tanksBeforeDisband.clear();
    }

    private void distributeFluidToTanks() {
        this.distributeFluidToTanks(false);
    }

    private void distributeFluidToTanks(boolean forceBlockUpdates) {
        int amountToDistribute = this.internalTank.getFluidAmount();
        int lightLevel = this.getFluidLuminosity();
        if (amountToDistribute == 0 || amountToDistribute == this.internalTank.getCapacity()) {
            int percentage = amountToDistribute == 0 ? 0 : 100;
            for (BlockCoords tankCoords : this.tankPriorities.values()) {
                TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tankCoords);
                if (tankEntity == null) continue;
                tankEntity.setFillPercentage(percentage, forceBlockUpdates);
            }
        } else {
            int[] priorities = Ints.toArray((Collection)this.tankPriorities.keySet());
            Arrays.sort(priorities);
            Collection tanksToFill = null;
            for (int i = 0; i < priorities.length; ++i) {
                tanksToFill = this.tankPriorities.get((Object)priorities[i]);
                int capacity = tanksToFill.size() * Config.bucketsPerTank * 1000;
                int fillPercentage = MathHelper.func_76125_a((int)((int)Math.ceil((double)amountToDistribute / (double)capacity * 100.0)), (int)0, (int)100);
                for (BlockCoords tank : tanksToFill) {
                    TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tank);
                    if (tankEntity == null) continue;
                    tankEntity.setFillPercentage(fillPercentage, forceBlockUpdates);
                }
                amountToDistribute -= Math.min(capacity, amountToDistribute);
            }
        }
    }

    private void generateTankList() {
        this.tanks = new HashSet();
        BlockCoords startCoords = new BlockCoords(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ArrayList<BlockCoords> currentTanks = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> newTanks = new ArrayList<BlockCoords>();
        currentTanks.add(startCoords);
        do {
            for (BlockCoords tank : currentTanks) {
                ArrayList<BlockCoords> adjacentTanks = this.findAdjacentTanks(tank);
                for (BlockCoords adjacentTank : adjacentTanks) {
                    if (!this.tanks.add(adjacentTank)) continue;
                    newTanks.add(adjacentTank);
                }
            }
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (currentTanks.size() > 0);
    }

    private void computeFillPriorities() {
        this.aStar = new BasicAStar();
        this.tankToPriorityMappings = new HashMap();
        BlockCoords startTank = new BlockCoords(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ArrayList<BlockCoords> tanksWithoutLowerTanks = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> currentTanks = new ArrayList<BlockCoords>();
        HashMap<BlockCoords, Integer> tanksToPrioritize = new HashMap<BlockCoords, Integer>();
        HashSet<BlockCoords> newTanks = new HashSet<BlockCoords>();
        HashSet<BlockCoords> handledSourceTanks = new HashSet<BlockCoords>();
        HashSet<BlockCoords> handledSegmentTanks = new HashSet<BlockCoords>();
        currentTanks.add(startTank);
        int priority = 0;
        do {
            for (BlockCoords blockCoords : currentTanks) {
                if (handledSegmentTanks.contains(blockCoords)) continue;
                ArrayList<BlockCoords> lowerTanks = this.getClosestLowestTanks(blockCoords);
                if (lowerTanks.get(0) == blockCoords) {
                    tanksWithoutLowerTanks.add(blockCoords);
                    handledSegmentTanks.addAll(lowerTanks);
                    continue;
                }
                handledSourceTanks.add(blockCoords);
                for (BlockCoords lowerTank : lowerTanks) {
                    tanksToPrioritize.put(lowerTank, priority);
                    newTanks.addAll(this.getAdjacentTanks(lowerTank, BlockSearchMode.Above));
                }
            }
            for (BlockCoords blockCoords : tanksWithoutLowerTanks) {
                ArrayList<BlockCoords> tanksOnSameHeight;
                if (tanksToPrioritize.containsKey(blockCoords) || !Collections.disjoint(tanksOnSameHeight = this.getTanksOnSameHeight(blockCoords), handledSourceTanks)) continue;
                for (BlockCoords tankOnSameHeight : tanksOnSameHeight) {
                    int adjustedPriority = this.tankToPriorityMappings.containsKey(tankOnSameHeight) ? Math.max(priority, this.tankToPriorityMappings.get(tankOnSameHeight)) : priority;
                    tanksToPrioritize.put(tankOnSameHeight, adjustedPriority);
                    newTanks.addAll(this.getAdjacentTanks(tankOnSameHeight, BlockSearchMode.Above));
                }
            }
            for (Map.Entry entry : tanksToPrioritize.entrySet()) {
                this.setTankPriority((BlockCoords)entry.getKey(), (Integer)entry.getValue());
            }
            ++priority;
            tanksWithoutLowerTanks.clear();
            handledSourceTanks.clear();
            handledSegmentTanks.clear();
            tanksToPrioritize.clear();
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (!currentTanks.isEmpty());
        this.aStar = null;
    }

    private ArrayList<BlockCoords> getTanksOnSameHeight(BlockCoords startTank) {
        if (startTank == null) {
            return null;
        }
        ArrayList<BlockCoords> foundTanks = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> currentTanks = new ArrayList<BlockCoords>();
        HashSet<BlockCoords> handledTanks = new HashSet<BlockCoords>();
        HashSet<BlockCoords> newTanks = new HashSet<BlockCoords>();
        currentTanks.add(startTank);
        do {
            for (BlockCoords currentTank : currentTanks) {
                if (currentTank.y == startTank.y) {
                    foundTanks.add(currentTank);
                }
                EnumSet<BlockSearchMode> searchFlags = currentTank.y < startTank.y ? BlockSearchMode.All : BlockSearchMode.SameLevelAndBelow;
                ArrayList<BlockCoords> adjacentTanks = this.getAdjacentTanks(currentTank, searchFlags);
                for (BlockCoords adjacentTank : adjacentTanks) {
                    if (handledTanks.contains(adjacentTank)) continue;
                    newTanks.add(adjacentTank);
                }
                handledTanks.add(currentTank);
            }
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (!currentTanks.isEmpty());
        return foundTanks;
    }

    private void setTankPriority(BlockCoords tank, int priority) {
        if (tank == null || priority < 0) {
            return;
        }
        Integer oldPriority = this.tankToPriorityMappings.put(tank, priority);
        if (oldPriority == null) {
            this.tankPriorities.put((Object)priority, (Object)tank);
        } else {
            this.tankPriorities.remove((Object)oldPriority, (Object)tank);
            this.tankPriorities.put((Object)priority, (Object)tank);
        }
    }

    private ArrayList<BlockCoords> getClosestLowestTanks(BlockCoords startTank) {
        if (startTank == null) {
            return null;
        }
        ArrayList<BlockCoords> tanksWithTanksBelow = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> newTanks = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> foundTanks = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> currentTanks = new ArrayList<BlockCoords>();
        currentTanks.add(startTank);
        do {
            for (BlockCoords currentTank : currentTanks) {
                ArrayList<BlockCoords> tanksInSegment = this.getTanksInSegment(currentTank);
                for (BlockCoords segmentTank : tanksInSegment) {
                    ArrayList<BlockCoords> adjacentTanks = this.getAdjacentTanks(segmentTank, BlockSearchMode.Below);
                    if (adjacentTanks.isEmpty() || this.hasPriority(adjacentTanks.get(0))) continue;
                    tanksWithTanksBelow.add(segmentTank);
                }
                if (!tanksWithTanksBelow.isEmpty()) {
                    ArrayList<BlockCoords> closestTanksWithTanksBelow = tanksWithTanksBelow.size() > 1 ? this.getClosestTanks(tanksInSegment, tanksWithTanksBelow, currentTank) : tanksWithTanksBelow;
                    for (BlockCoords closestTank : closestTanksWithTanksBelow) {
                        newTanks.add(closestTank.offset(0));
                    }
                } else {
                    foundTanks.addAll(tanksInSegment);
                }
                tanksWithTanksBelow.clear();
            }
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (!currentTanks.isEmpty());
        return foundTanks;
    }

    private ArrayList<BlockCoords> getClosestTanks(Collection<BlockCoords> passableBlocks, Collection<BlockCoords> sources, BlockCoords destination) {
        if (this.tanks == null || this.tanks.isEmpty() || sources == null || sources.isEmpty() || destination == null) {
            return null;
        }
        ArrayList<Integer> distances = new ArrayList<Integer>();
        ArrayListMultimap distanceToTanksMappings = ArrayListMultimap.create();
        this.aStar.setPassableBlocks(this.tanks);
        for (BlockCoords source : sources) {
            int distance = source.equals(destination) ? 0 : this.aStar.getShortestPath((BlockCoords)source, (BlockCoords)destination).currentCost;
            distances.add(distance);
            distanceToTanksMappings.put((Object)distance, (Object)source);
        }
        Collections.sort(distances);
        return new ArrayList<BlockCoords>(distanceToTanksMappings.get(distances.get(0)));
    }

    private ArrayList<BlockCoords> getTanksInSegment(BlockCoords firstTank) {
        if (firstTank == null) {
            return null;
        }
        LinkedHashSet<BlockCoords> foundTanks = new LinkedHashSet<BlockCoords>();
        foundTanks.add(firstTank);
        ArrayList<BlockCoords> currentTanks = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> newTanks = new ArrayList<BlockCoords>();
        currentTanks.add(firstTank);
        do {
            for (BlockCoords currentTank : currentTanks) {
                ArrayList<BlockCoords> adjacentTanks = this.getAdjacentTanks(currentTank, BlockSearchMode.SameLevel);
                for (BlockCoords adjacentTank : adjacentTanks) {
                    if (!foundTanks.add(adjacentTank)) continue;
                    newTanks.add(adjacentTank);
                }
            }
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (!currentTanks.isEmpty());
        return new ArrayList<BlockCoords>(foundTanks);
    }

    private ArrayList<BlockCoords> getAdjacentTanks(BlockCoords block) {
        return this.getOrFindAdjacentTanks(block, null, BlockSearchMode.All, true);
    }

    private ArrayList<BlockCoords> getAdjacentTanks(BlockCoords block, BlockSearchMode mode) {
        return this.getOrFindAdjacentTanks(block, mode, null, true);
    }

    private ArrayList<BlockCoords> getAdjacentTanks(BlockCoords block, EnumSet<BlockSearchMode> searchFlags) {
        return this.getOrFindAdjacentTanks(block, null, searchFlags, true);
    }

    private ArrayList<BlockCoords> findAdjacentTanks(BlockCoords block) {
        return this.getOrFindAdjacentTanks(block, null, BlockSearchMode.All, false);
    }

    private ArrayList<BlockCoords> findAdjacentTanks(BlockCoords block, BlockSearchMode mode) {
        return this.getOrFindAdjacentTanks(block, mode, null, false);
    }

    private ArrayList<BlockCoords> findAdjacentTanks(BlockCoords block, EnumSet<BlockSearchMode> searchFlags) {
        return this.getOrFindAdjacentTanks(block, null, searchFlags, false);
    }

    private ArrayList<BlockCoords> getOrFindAdjacentTanks(BlockCoords block, BlockSearchMode mode, EnumSet<BlockSearchMode> searchFlags, boolean useTankList) {
        if (block == null || mode == null && searchFlags == null) {
            return null;
        }
        ArrayList<BlockCoords> foundTanks = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> adjacentBlocks = new ArrayList<BlockCoords>();
        if (mode == BlockSearchMode.SameLevel || searchFlags != null && searchFlags.contains((Object)BlockSearchMode.SameLevel)) {
            adjacentBlocks.add(new BlockCoords(block.x + 1, block.y, block.z));
            adjacentBlocks.add(new BlockCoords(block.x - 1, block.y, block.z));
            adjacentBlocks.add(new BlockCoords(block.x, block.y, block.z + 1));
            adjacentBlocks.add(new BlockCoords(block.x, block.y, block.z - 1));
        }
        if (mode == BlockSearchMode.Above || searchFlags != null && searchFlags.contains((Object)BlockSearchMode.Above)) {
            adjacentBlocks.add(new BlockCoords(block.x, block.y + 1, block.z));
        }
        if (mode == BlockSearchMode.Below || searchFlags != null && searchFlags.contains((Object)BlockSearchMode.Below)) {
            adjacentBlocks.add(new BlockCoords(block.x, block.y - 1, block.z));
        }
        if (useTankList) {
            for (BlockCoords adjacentBlock : adjacentBlocks) {
                if (!this.isInTankList(adjacentBlock)) continue;
                foundTanks.add(adjacentBlock);
            }
        } else {
            for (BlockCoords adjacentBlock : adjacentBlocks) {
                if (!this.isUnlinkedTank(adjacentBlock)) continue;
                foundTanks.add(adjacentBlock);
            }
        }
        return foundTanks;
    }

    private boolean isUnlinkedTank(BlockCoords block) {
        if (block == null) {
            return false;
        }
        if (this.field_145850_b.func_147439_a(block.x, block.y, block.z) instanceof TankBlock) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, block);
            if (tankEntity != null) {
                return !tankEntity.isPartOfTank();
            }
        } else if (block.equals(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.tankPriorities.isEmpty()) {
            return true;
        }
        return false;
    }

    private boolean isInTankList(BlockCoords block) {
        if (block == null) {
            return false;
        }
        if (this.tanks != null) {
            return this.tanks.contains(block);
        }
        if (this.tankPriorities != null) {
            return this.tankPriorities.values().contains(block);
        }
        return false;
    }

    private boolean hasPriority(BlockCoords tank) {
        return this.tankPriorities.containsValue((Object)tank);
    }

    private void writeTankPrioritiesToNBT(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        NBTTagCompound tankPrioritiesTag = new NBTTagCompound();
        int i = 0;
        for (Map.Entry entry : this.tankPriorities.entries()) {
            BlockCoords currentCoords = (BlockCoords)entry.getValue();
            int[] serializableEntry = new int[]{(Integer)entry.getKey(), currentCoords.x, currentCoords.y, currentCoords.z};
            tankPrioritiesTag.func_74783_a(Integer.toString(i), serializableEntry);
            ++i;
        }
        tag.func_74782_a("TankPriorities", (NBTBase)tankPrioritiesTag);
    }

    private void readTankPrioritiesFromNBT(NBTTagCompound tag) {
        this.tankPriorities = ArrayListMultimap.create();
        if (tag != null) {
            String key;
            NBTTagCompound tankPrioritiesTag = tag.func_74775_l("TankPriorities");
            int i = 0;
            while (tankPrioritiesTag.func_74764_b(key = Integer.toString(i))) {
                int[] serializedEntry = tankPrioritiesTag.func_74759_k(key);
                this.tankPriorities.put((Object)serializedEntry[0], (Object)new BlockCoords(serializedEntry[1], serializedEntry[2], serializedEntry[3]));
                ++i;
            }
        }
    }
}

