/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCommand;
import net.malisis.core.configuration.ConfigurationGui;
import net.malisis.core.configuration.Settings;
import net.malisis.core.packet.NetworkHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

public class MalisisCore
extends DummyModContainer
implements IMalisisMod {
    public static final String modid = "malisiscore";
    public static final String modname = "Malisis Core";
    public static final String version = "1.7.2-0.9.1";
    public static final String url = "";
    public static File coremodLocation;
    public static MalisisCore instance;
    public static Logger log;
    private HashMap<String, IMalisisMod> registeredMods = new HashMap();
    public static boolean isObfEnv;
    private HashMap<Block, Block> originals = new HashMap();
    private boolean keepConfigurationGuiOpen;

    public MalisisCore() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = modid;
        meta.name = modname;
        meta.version = version;
        meta.authorList = Arrays.asList("Ordinastie", "PaleoCrafter");
        meta.url = "http://github.com/Ordinastie/MalisisCore";
        meta.logoFile = "malisiscore.png";
        meta.description = "API rendering and ASM transformations.";
        instance = this;
    }

    @Override
    public String getModId() {
        return modid;
    }

    @Override
    public String getName() {
        return modname;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Settings getSettings() {
        return null;
    }

    public static void registerMod(IMalisisMod mod) {
        MalisisCore.instance.registeredMods.put(mod.getModId(), mod);
    }

    public static IMalisisMod getMod(String id) {
        return MalisisCore.instance.registeredMods.get(id);
    }

    public static Set<String> listModId() {
        return MalisisCore.instance.registeredMods.keySet();
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public static void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        log = event.getModLog();
    }

    @Subscribe
    public static void init(FMLInitializationEvent event) {
        NetworkHandler.init(modid);
        ClientCommandHandler.instance.func_71560_a((ICommand)new MalisisCommand());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            return;
        }
        for (Map.Entry<Block, Block> entry : this.originals.entrySet()) {
            Block block = entry.getValue();
            block.func_149651_a((IIconRegister)event.map);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiClose(GuiOpenEvent event) {
        if (!this.keepConfigurationGuiOpen || event.gui != null) {
            return;
        }
        this.keepConfigurationGuiOpen = false;
        event.setCanceled(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean openConfigurationGui(IMalisisMod mod, boolean keepOpen) {
        Settings settings = mod.getSettings();
        if (settings == null) {
            return false;
        }
        MalisisCore.instance.keepConfigurationGuiOpen = keepOpen;
        new ConfigurationGui(settings).display();
        return true;
    }

    public static void replaceVanillaBlock(int id, String name, String srgFieldName, Block block, Block vanilla) {
        try {
            ItemBlock ib = (ItemBlock)Item.func_150898_a((Block)vanilla);
            Class[] types = new Class[]{Integer.TYPE, String.class, Object.class};
            Method method = ReflectionHelper.findMethod(FMLControlledNamespacedRegistry.class, (Object)null, (String[])new String[]{"addObjectRaw"}, (Class[])types);
            method.invoke((Object)Block.field_149771_c, id, "minecraft:" + name, block);
            Field f = ReflectionHelper.findField(Blocks.class, (String[])new String[]{isObfEnv ? srgFieldName : name});
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(null, block);
            if (ib != null) {
                f = ReflectionHelper.findField(ItemBlock.class, (String[])new String[]{"field_150939_a"});
                modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
                modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                f.set(ib, block);
            }
            MalisisCore.instance.originals.put(block, vanilla);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static Block orignalBlock(Block block) {
        return MalisisCore.instance.originals.get(block);
    }

    public static void message(Object text, Object ... data) {
        if (text == null) {
            return;
        }
        ChatComponentText msg = new ChatComponentText(StatCollector.func_74837_a((String)text.toString(), (Object[])data));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server != null) {
                server.func_71203_ab().func_148539_a((IChatComponent)msg);
            }
        } else {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)msg);
        }
    }

    public File getSource() {
        return coremodLocation;
    }

    public Class<?> getCustomResourcePackClass() {
        return coremodLocation.isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    static {
        isObfEnv = false;
    }
}

