/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import java.util.Arrays;
import java.util.List;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.minecraft.util.IIcon;

public class UITooltip
extends UIComponent {
    public static GuiIcon[] icons = new GuiIcon[]{new GuiIcon(227, 31, 5, 5), new GuiIcon(232, 31, 5, 5), new GuiIcon(237, 31, 5, 5), new GuiIcon(227, 36, 5, 5), new GuiIcon(232, 36, 5, 5), new GuiIcon(237, 36, 5, 5), new GuiIcon(227, 41, 5, 5), new GuiIcon(232, 41, 5, 5), new GuiIcon(237, 41, 5, 5)};
    protected List<String> lines;
    protected int padding = 4;

    public UITooltip() {
        this.width = 16;
        this.height = 16;
        this.zIndex = 300;
    }

    public UITooltip(String text) {
        this();
        this.setText(text);
    }

    public UITooltip setText(String text) {
        this.lines = Arrays.asList(text.split("\\n"));
        this.calcSize();
        return this;
    }

    public UITooltip setText(List<String> lines) {
        this.lines = lines;
        this.calcSize();
        return this;
    }

    protected void calcSize() {
        this.width = Math.max(16, GuiRenderer.getMaxStringWidth(this.lines));
        this.width += this.padding * 2;
        this.height = this.lines.size() > 1 ? (GuiRenderer.FONT_HEIGHT + 1) * this.lines.size() : 8;
        this.height += this.padding * 2;
    }

    protected int getOffsetX() {
        return 8;
    }

    protected int getOffsetY() {
        return -16;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = ShapePreset.GuiXYResizable(this.width, this.height);
        shape.translate(mouseX + this.getOffsetX(), mouseY + this.getOffsetY(), 0.0f);
        RenderParameters rp = new RenderParameters();
        rp.alpha.set(255);
        renderer.drawShape(shape, rp, (IIcon[])icons);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int x = mouseX + this.getOffsetX() + this.padding;
        int y = mouseY + this.getOffsetY() + this.padding;
        int i = 0;
        for (String s : this.lines) {
            int sy = y;
            if (i > 0) {
                sy += 2;
            }
            renderer.drawString(s, x, sy + (GuiRenderer.FONT_HEIGHT + 1) * i, this.zIndex + 1, 0xFFFFFF, true);
            ++i;
        }
    }
}

