/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.eventbus.Subscribe;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.MouseButton;
import net.minecraft.util.IIcon;

public class UIButton
extends UIComponent<UIButton> {
    public static GuiIcon[] iconButton = new GuiIcon[]{new GuiIcon(0, 20, 5, 20), new GuiIcon(5, 20, 15, 20), new GuiIcon(195, 20, 5, 20)};
    public static GuiIcon[] iconButtonHovered = new GuiIcon[]{iconButton[0].offsetCopy(0, 20), iconButton[1].offsetCopy(0, 20), iconButton[2].offsetCopy(0, 20)};
    public static GuiIcon[] iconButtonDisabled = new GuiIcon[]{iconButton[0].offsetCopy(0, -20), iconButton[1].offsetCopy(0, -20), iconButton[2].offsetCopy(0, -20)};
    private UILabel label = new UILabel();
    private boolean autoWidth = true;

    public UIButton(String text, int width) {
        this.setText(text);
        this.label.setDrawShadow(true);
        this.setSize(width);
    }

    public UIButton(String text) {
        this(text, 60);
    }

    public UIButton() {
        this(null, 60);
    }

    public UIButton setText(String text) {
        this.label.setText(text);
        this.setSize(this.autoWidth ? 0 : this.width);
        return this;
    }

    public UIButton setSize(int width) {
        this.autoWidth = width == 0;
        int extraWidth = this.label.getWidth() % 2 == 0 ? 6 : 7;
        this.width = Math.max(width, this.label.getWidth() + extraWidth);
        this.height = 20;
        return this;
    }

    @Override
    public UIButton setSize(int width, int height) {
        return this.setSize(width);
    }

    @Override
    public UIButton setZIndex(int zIndex) {
        super.setZIndex(zIndex);
        this.label.setZIndex(zIndex + 1);
        return this;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        IIcon[] icons = this.isDisabled() ? iconButtonDisabled : (this.hovered ? iconButtonHovered : iconButton);
        Shape shape = ShapePreset.GuiXResizable(this.width, this.height);
        renderer.drawShape(shape, icons);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int x = (this.width - this.label.getWidth()) / 2;
        int y = (this.height - this.label.getHeight() + 2) / 2;
        this.label.setColor(this.isHovered() ? 0xFFFFA0 : 0xFFFFFF);
        this.label.setPosition(this.screenX() + x, this.screenY() + y);
        this.label.draw(renderer, mouseX, mouseY, partialTick);
    }

    @Subscribe
    public void onClick(MouseEvent.Release event) {
        if (event.getButton() == MouseButton.LEFT) {
            this.fireEvent(new ClickedEvent(this, event));
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[ text=" + this.label.getText() + ", " + this.getPropertyString() + " ]";
    }

    public static class ClickedEvent
    extends ComponentEvent<UIButton> {
        private int x;
        private int y;
        private MouseButton button;
        private int buttonCode;

        public ClickedEvent(UIButton component, MouseEvent.Release mouseEvent) {
            super(component);
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            this.button = mouseEvent.getButton();
            this.buttonCode = mouseEvent.getButtonCode();
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public MouseButton getButton() {
            return this.button;
        }

        public int getButtonCode() {
            return this.buttonCode;
        }
    }
}

