/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import net.malisis.core.client.gui.GuiIcon;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UITabGroup;
import net.malisis.core.client.gui.event.MouseEvent;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.MouseButton;
import net.minecraft.util.IIcon;

public class UITab
extends UIComponent<UITab> {
    public static GuiIcon[] icons = new GuiIcon[]{new GuiIcon(200, 15, 5, 5), new GuiIcon(205, 15, 5, 5), new GuiIcon(210, 15, 5, 5), new GuiIcon(200, 20, 5, 5), new GuiIcon(205, 20, 5, 5), new GuiIcon(210, 20, 5, 5)};
    protected String label;
    protected boolean autoWidth = false;
    protected UIContainer container;
    protected boolean active = false;

    public UITab(int width, String label) {
        this.setSize(width, 0);
        this.setLabel(label);
    }

    public UITab(String label) {
        this(0, label);
    }

    @Override
    public UITab setSize(int width, int height) {
        this.height = 17;
        this.width = width;
        if (width == 0) {
            this.autoWidth = true;
        }
        return this;
    }

    @Override
    public UITab setPosition(int x, int y, int anchor) {
        return (UITab)super.setPosition(x, y + 1, anchor);
    }

    public UITab setLabel(String label) {
        this.label = label;
        if (this.autoWidth) {
            this.width = GuiRenderer.getStringWidth(label) + 8;
        }
        return this;
    }

    public UITab setContainer(UIContainer container) {
        this.container = container;
        return this;
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.y += active ? -1 : 1;
            this.height += active ? 1 : -1;
        }
        this.active = active;
        this.container.setVisible(active);
        this.container.setDisabled(!active);
        this.zIndex = active ? this.container.getZIndex() + 1 : 0;
    }

    @Subscribe
    public void onClick(MouseEvent.Release event) {
        if (event.getButton() != MouseButton.LEFT) {
            return;
        }
        if (!(this.parent instanceof UITabGroup)) {
            return;
        }
        ((UITabGroup)this.parent).setActiveTab(this);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        Shape shape = new Shape(Arrays.copyOf(ShapePreset.GuiXYResizable(this.width, this.height).getFaces(), 6));
        RenderParameters rp = new RenderParameters();
        renderer.drawShape(shape, rp, (IIcon[])icons);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int x = (this.width - GuiRenderer.getStringWidth(this.label)) / 2;
        int y = 3;
        int color = this.isHovered() ? 0xFFFFA0 : (this.active ? 0xFFFFFF : 0x404040);
        renderer.drawText(this.label, x, y, this.zIndex, color, this.active);
    }
}

