/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.packet.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class OpenIventoryMessage
implements IMessageHandler<Packet, IMessage> {
    public IMessage onMessage(Packet message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.openGui(message.type, message.x, message.y, message.z, message.windowId);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(ContainerType type, int x, int y, int z, int windowId) {
        TileEntity te;
        if (type == ContainerType.TYPE_TILEENTITY && (te = Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z)) instanceof IInventoryProvider) {
            ((IInventoryProvider)te).getInventory().open(Minecraft.func_71410_x().field_71439_g, windowId);
        }
    }

    public static void send(IInventoryProvider container, EntityPlayerMP player, int windowId) {
        Packet packet = new Packet(container, windowId);
        NetworkHandler.network.sendTo((IMessage)packet, player);
    }

    public static class Packet
    implements IMessage {
        private ContainerType type;
        private int x;
        private int y;
        private int z;
        private int windowId;

        public Packet() {
        }

        public Packet(IInventoryProvider container, int windowId) {
            this.windowId = windowId;
            if (container instanceof TileEntity) {
                this.type = ContainerType.TYPE_TILEENTITY;
                this.x = ((TileEntity)container).field_145851_c;
                this.y = ((TileEntity)container).field_145848_d;
                this.z = ((TileEntity)container).field_145849_e;
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.type = ContainerType.values()[buf.readByte()];
            if (this.type == ContainerType.TYPE_TILEENTITY) {
                this.x = buf.readInt();
                this.y = buf.readInt();
                this.z = buf.readInt();
                this.windowId = buf.readInt();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.type.ordinal());
            if (this.type == ContainerType.TYPE_TILEENTITY) {
                buf.writeInt(this.x);
                buf.writeInt(this.y);
                buf.writeInt(this.z);
                buf.writeInt(this.windowId);
            }
        }
    }

    public static enum ContainerType {
        TYPE_TILEENTITY,
        TYPE_ITEM;

    }
}

