/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.packet.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class UpdateInventorySlotsMessage
implements IMessageHandler<Packet, IMessage> {
    public IMessage onMessage(Packet message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.updateSlots(message.type, message.slots, message.windowId);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSlots(SlotType type, HashMap<Integer, ItemStack> slots, int windowId) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Container c = player.field_71070_bA;
        if (windowId != c.field_75152_c || !(c instanceof MalisisInventoryContainer)) {
            return;
        }
        MalisisInventoryContainer container = (MalisisInventoryContainer)c;
        if (type == SlotType.TYPE_PICKEDITEM) {
            container.setPickedItemStack(slots.get(-1));
            return;
        }
        if (type == SlotType.TYPE_DRAGGEDITEMS) {
            container.setDraggedItems(slots);
            return;
        }
        MalisisInventory inventory = type == SlotType.TYPE_INVENTORY ? container.getContainerInventory() : container.getPlayerInventory();
        for (Map.Entry<Integer, ItemStack> entry : slots.entrySet()) {
            Integer slotNumber = entry.getKey();
            ItemStack itemStack = entry.getValue();
            inventory.setItemStack(slotNumber, itemStack);
        }
    }

    public static void updatePickedItemStack(ItemStack itemStack, EntityPlayerMP player, int windowId) {
        Packet packet = new Packet(SlotType.TYPE_PICKEDITEM, windowId);
        packet.draggedItemStack(itemStack);
        NetworkHandler.network.sendTo((IMessage)packet, player);
    }

    public static void updateSlots(SlotType type, ArrayList<MalisisSlot> slots, EntityPlayerMP player, int windowId) {
        Packet packet = new Packet(type, windowId);
        for (MalisisSlot slot : slots) {
            packet.addSlot(slot);
        }
        NetworkHandler.network.sendTo((IMessage)packet, player);
    }

    public static void updateDraggedItemStacks(HashMap<Integer, ItemStack> slots, EntityPlayerMP player, int windowId) {
        Packet packet = new Packet(SlotType.TYPE_DRAGGEDITEMS, windowId);
        packet.setSlots(slots);
        NetworkHandler.network.sendTo((IMessage)packet, player);
    }

    public static class Packet
    implements IMessage {
        private SlotType type;
        private HashMap<Integer, ItemStack> slots = new HashMap();
        private int windowId;

        public Packet() {
        }

        public Packet(SlotType type, int windowId) {
            this.type = type;
            this.windowId = windowId;
        }

        public void addSlot(MalisisSlot slot) {
            this.slots.put(slot.slotNumber, slot.getItemStack());
        }

        public void setSlots(HashMap<Integer, ItemStack> slots) {
            if (slots != null) {
                this.slots = slots;
            }
        }

        public void draggedItemStack(ItemStack itemStack) {
            this.slots.put(-1, itemStack);
        }

        public void fromBytes(ByteBuf buf) {
            this.type = SlotType.values()[buf.readByte()];
            this.windowId = buf.readInt();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.slots.put(buf.readInt(), ByteBufUtils.readItemStack((ByteBuf)buf));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.type.ordinal());
            buf.writeInt(this.windowId);
            buf.writeInt(this.slots.size());
            for (Map.Entry<Integer, ItemStack> entry : this.slots.entrySet()) {
                Integer slotNumber = entry.getKey();
                ItemStack itemStack = entry.getValue();
                buf.writeInt(slotNumber.intValue());
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)itemStack);
            }
        }
    }

    public static enum SlotType {
        TYPE_INVENTORY,
        TYPE_PLAYERINVENTORY,
        TYPE_PICKEDITEM,
        TYPE_DRAGGEDITEMS;

    }
}

