/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import java.util.ArrayList;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Shape;

public class ChainedTransformation
extends Transformation<ChainedTransformation> {
    protected ArrayList<Transformation> listTransformations = new ArrayList();
    private boolean reversed = false;

    public ChainedTransformation(Transformation ... transformations) {
        this.addTransformations(transformations);
    }

    public ChainedTransformation addTransformations(Transformation ... transformations) {
        this.duration = 0;
        for (Transformation transformation : transformations) {
            this.duration += transformation.totalDuration();
            this.listTransformations.add(transformation);
        }
        return this;
    }

    @Override
    protected void doTransform(Shape s, float comp) {
        if (this.listTransformations.size() == 0) {
            return;
        }
        if (this.reversed) {
            this.elapsedTimeCurrentLoop = Math.max(0.0f, (float)this.duration - this.elapsedTimeCurrentLoop);
        }
        for (Transformation transformation : this.listTransformations) {
            transformation.transform(s, this.elapsedTimeCurrentLoop);
            this.elapsedTimeCurrentLoop -= (float)transformation.totalDuration();
        }
    }

    @Override
    public ChainedTransformation reversed(boolean reversed) {
        this.reversed = reversed;
        return this;
    }
}

