/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import java.util.ArrayList;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Shape;

public class ParallelTransformation
extends Transformation<ParallelTransformation> {
    protected ArrayList<Transformation> listTransformations = new ArrayList();

    public ParallelTransformation(Transformation ... transformations) {
        this.addTransformations(transformations);
    }

    public ParallelTransformation addTransformations(Transformation ... transformations) {
        for (Transformation transformation : transformations) {
            this.duration = Math.max(this.duration, transformation.totalDuration());
            this.listTransformations.add(transformation);
        }
        return this;
    }

    @Override
    protected void doTransform(Shape s, float comp) {
        if (this.listTransformations.size() == 0) {
            return;
        }
        for (Transformation transformation : this.listTransformations) {
            transformation.transform(s, this.elapsedTimeCurrentLoop);
        }
    }

    @Override
    public ParallelTransformation reversed(boolean reversed) {
        if (!reversed) {
            return this;
        }
        for (Transformation transformation : this.listTransformations) {
            transformation.reversed(true);
        }
        return this;
    }
}

