/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.element.Shape;

public abstract class Transformation<T extends Transformation> {
    public static final int LINEAR = 0;
    public static final int SINUSOIDAL = 1;
    public int movement = 0;
    protected int duration;
    protected int delay = 0;
    protected int loops = 1;
    protected int loopStartDelay = 0;
    protected int loopResetDelay = 0;
    protected float elapsedTimeCurrentLoop;

    public T movement(int movement) {
        this.movement = movement;
        return (T)this;
    }

    public T delay(int delay) {
        this.delay = delay;
        return (T)this;
    }

    public T forTicks(int duration) {
        return this.forTicks(duration, 0);
    }

    public T forTicks(int duration, int delay) {
        if (this.duration == 0) {
            this.duration = duration;
            this.delay = delay;
        }
        return (T)this;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getLoops() {
        return this.loops;
    }

    public int totalDuration() {
        if (this.loops == -1) {
            return Integer.MAX_VALUE;
        }
        return this.delay + this.loops * this.getLoopDuration();
    }

    public int getLoopDuration() {
        return this.duration + this.loopStartDelay + this.loopResetDelay;
    }

    public T loop(int loops) {
        return this.loop(loops, 0, 0);
    }

    public T loop(int loops, int startDelay, int resetDelay) {
        if (loops == 0) {
            return (T)this;
        }
        this.loops = loops;
        this.loopStartDelay = startDelay;
        this.loopResetDelay = resetDelay;
        return (T)this;
    }

    public void transform(Shape s, float elapsedTime) {
        this.doTransform(s, this.completion(Math.max(0.0f, elapsedTime)));
    }

    protected float completion(float elapsedTime) {
        if (this.duration == 0) {
            return 0.0f;
        }
        float comp = 0.0f;
        int loopDuration = this.getLoopDuration();
        this.elapsedTimeCurrentLoop = elapsedTime - (float)this.delay;
        if (this.loops != -1 && this.elapsedTimeCurrentLoop > (float)(this.loops * loopDuration)) {
            return 1.0f;
        }
        if (this.loops != 1) {
            this.elapsedTimeCurrentLoop %= (float)loopDuration;
            if (this.elapsedTimeCurrentLoop < (float)this.loopStartDelay) {
                return 0.0f;
            }
            if (this.elapsedTimeCurrentLoop - (float)this.loopResetDelay > (float)loopDuration) {
                return 1.0f;
            }
            this.elapsedTimeCurrentLoop -= (float)this.loopStartDelay;
        }
        comp = Math.min(this.elapsedTimeCurrentLoop / (float)this.duration, 1.0f);
        if (this.movement == 1) {
            comp = (float)(1.0 - Math.cos((double)comp * Math.PI)) / 2.0f;
        }
        comp = Math.max(0.0f, Math.min(1.0f, comp));
        return comp;
    }

    protected abstract void doTransform(Shape var1, float var2);

    public abstract T reversed(boolean var1);
}

