/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import java.util.HashMap;
import java.util.List;
import net.malisis.core.renderer.MalisisIcon;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Vertex;
import net.minecraft.util.IIcon;

public class Face {
    private Vertex[] vertexes;
    private RenderParameters params = new RenderParameters();

    public Face(Vertex[] vertexes, RenderParameters params) {
        this.vertexes = new Vertex[vertexes.length];
        for (int i = 0; i < vertexes.length; ++i) {
            this.vertexes[i] = new Vertex(vertexes[i]);
        }
        this.params = params != null ? params : new RenderParameters();
    }

    public Face(Vertex[] vertexes) {
        this(vertexes, null);
    }

    public Face(List<Vertex> vertexes) {
        this(vertexes.toArray(new Vertex[0]), null);
    }

    public Face(Face face) {
        this(face, new RenderParameters(face.params));
    }

    public Face(Face face, RenderParameters params) {
        this(face.vertexes, params);
    }

    public Vertex[] getVertexes() {
        return this.vertexes;
    }

    public Face setParameters(RenderParameters params) {
        this.params = params != null ? params : new RenderParameters();
        return this;
    }

    public RenderParameters getParameters() {
        return this.params;
    }

    public Face setColor(int color) {
        for (Vertex v : this.vertexes) {
            v.setColor(color);
        }
        return this;
    }

    public Face setAlpha(int alpha) {
        for (Vertex v : this.vertexes) {
            v.setAlpha(alpha);
        }
        return this;
    }

    public Face setBrightness(int brightness) {
        for (Vertex v : this.vertexes) {
            v.setBrightness(brightness);
        }
        return this;
    }

    public Face setTexture(IIcon icon) {
        return this.setTexture(icon, this.params.flipU.get(), this.params.flipV.get(), false);
    }

    public Face setStandardUV() {
        this.vertexes[0].setUV(0.0f, 0.0f);
        this.vertexes[1].setUV(0.0f, 1.0f);
        this.vertexes[2].setUV(1.0f, 1.0f);
        this.vertexes[3].setUV(1.0f, 0.0f);
        return this;
    }

    public Face setTexture(IIcon icon, boolean flippedU, boolean flippedV, boolean interpolate) {
        int i;
        if (icon == null) {
            return this;
        }
        float u = icon.func_94209_e();
        float v = icon.func_94206_g();
        float U = icon.func_94212_f();
        float V = icon.func_94210_h();
        float[][] uvs = new float[this.vertexes.length][2];
        for (i = 0; i < this.vertexes.length; ++i) {
            Vertex vertex = this.vertexes[i];
            double factorU = interpolate ? this.getFactorU(vertex) : vertex.getU();
            double factorV = interpolate ? this.getFactorV(vertex) : vertex.getV();
            int k = i;
            if (icon instanceof MalisisIcon) {
                k = (i + ((MalisisIcon)icon).getRotation()) % this.vertexes.length;
            }
            uvs[k] = new float[]{this.interpolate(u, U, factorU, flippedU), this.interpolate(v, V, factorV, flippedV)};
        }
        for (i = 0; i < this.vertexes.length; ++i) {
            this.vertexes[i].setUV(uvs[i][0], uvs[i][1]);
        }
        return this;
    }

    private double getFactorU(Vertex vertex) {
        if (this.params.textureSide.get() == null) {
            return vertex.getU();
        }
        switch (this.params.textureSide.get()) {
            case EAST: {
                return vertex.getZ();
            }
            case WEST: {
                return vertex.getZ();
            }
            case NORTH: {
                return vertex.getX();
            }
            case SOUTH: 
            case UP: 
            case DOWN: {
                return vertex.getX();
            }
        }
        return 0.0;
    }

    private double getFactorV(Vertex vertex) {
        if (this.params.textureSide.get() == null) {
            return vertex.getV();
        }
        switch (this.params.textureSide.get()) {
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return 1.0 - vertex.getY();
            }
            case UP: 
            case DOWN: {
                return vertex.getZ();
            }
        }
        return 0.0;
    }

    private float interpolate(float min, float max, double factor, boolean flipped) {
        if (factor > 1.0) {
            factor = 1.0;
        }
        if (factor < 0.0) {
            factor = 0.0;
        }
        if (flipped) {
            factor = 1.0 - factor;
            float t = max;
            max = min;
            min = t;
        }
        return min + (max - min) * (float)factor;
    }

    public Face factor(float fx, float fy, float fz) {
        for (Vertex v : this.vertexes) {
            v.factorX(fx);
            v.factorY(fy);
            v.factorZ(fz);
        }
        return this;
    }

    public Face translate(double x, double y, double z) {
        for (Vertex v : this.vertexes) {
            v.add(x, y, z);
        }
        return this;
    }

    public void scale(float f) {
        this.scale(f, 0.5, 0.5, 0.5);
    }

    public void scale(float f, double x, double y, double z) {
        for (Vertex v : this.vertexes) {
            v.scale(f, x, y, z);
        }
    }

    public void rotateAroundX(double angle) {
        this.rotateAroundX(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundX(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundX(angle, centerX, centerY, centerZ);
        }
    }

    public void rotateAroundY(double angle) {
        this.rotateAroundY(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundY(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundY(angle, centerX, centerY, centerZ);
        }
    }

    public void rotateAroundZ(double angle) {
        this.rotateAroundZ(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundZ(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundZ(angle, centerX, centerY, centerZ);
        }
    }

    public String name() {
        String[] dirs;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String dir : dirs = new String[]{"North", "South", "East", "West", "Top", "Bottom"}) {
            map.put(dir, 0);
            for (Vertex v : this.vertexes) {
                if (!v.name().contains(dir)) continue;
                map.put(dir, (Integer)map.get(dir) + 1);
            }
            if ((Integer)map.get(dir) != 4) continue;
            return dir;
        }
        return "";
    }

    public String toString() {
        String s = this.name() + "[";
        for (Vertex v : this.vertexes) {
            s = s + v.name() + ", ";
        }
        return s + "]";
    }
}

