/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.preset;

import java.util.HashMap;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Vertex;
import net.minecraftforge.common.util.ForgeDirection;

public class FacePreset {
    private static Face Bottom = new Face(new Vertex[]{Vertex.BottomNorthEast, Vertex.BottomSouthEast, Vertex.BottomSouthWest, Vertex.BottomNorthWest});
    private static Face Top = new Face(new Vertex[]{Vertex.TopNorthWest, Vertex.TopSouthWest, Vertex.TopSouthEast, Vertex.TopNorthEast});
    private static Face West = new Face(new Vertex[]{Vertex.TopNorthWest, Vertex.BottomNorthWest, Vertex.BottomSouthWest, Vertex.TopSouthWest});
    private static Face North = new Face(new Vertex[]{Vertex.TopNorthEast, Vertex.BottomNorthEast, Vertex.BottomNorthWest, Vertex.TopNorthWest});
    private static Face East = new Face(new Vertex[]{Vertex.TopSouthEast, Vertex.BottomSouthEast, Vertex.BottomNorthEast, Vertex.TopNorthEast});
    private static Face South = new Face(new Vertex[]{Vertex.TopSouthWest, Vertex.BottomSouthWest, Vertex.BottomSouthEast, Vertex.TopSouthEast});
    private static Face NorthWest = new Face(new Vertex[]{Vertex.TopNorthEast, Vertex.BottomNorthEast, Vertex.BottomSouthWest, Vertex.TopSouthWest});
    private static Face NorthEast = new Face(new Vertex[]{Vertex.TopSouthEast, Vertex.BottomSouthEast, Vertex.BottomNorthWest, Vertex.TopNorthWest});
    private static Face SouthWest = new Face(new Vertex[]{Vertex.TopNorthWest, Vertex.BottomNorthWest, Vertex.BottomSouthEast, Vertex.TopSouthEast});
    private static Face SouthEast = new Face(new Vertex[]{Vertex.TopSouthWest, Vertex.BottomSouthWest, Vertex.BottomNorthEast, Vertex.TopNorthEast});
    private static Face TopNorth = new Face(new Vertex[]{Vertex.TopSouthEast, Vertex.BottomNorthEast, Vertex.BottomNorthWest, Vertex.TopSouthWest});
    private static Face TopEast = new Face(new Vertex[]{Vertex.TopSouthWest, Vertex.BottomSouthEast, Vertex.BottomNorthEast, Vertex.TopNorthWest});
    private static Face TopSouth = new Face(new Vertex[]{Vertex.TopNorthWest, Vertex.BottomSouthWest, Vertex.BottomSouthEast, Vertex.TopNorthEast});
    private static Face TopWest = new Face(new Vertex[]{Vertex.TopNorthEast, Vertex.BottomNorthWest, Vertex.BottomSouthWest, Vertex.TopSouthEast});
    private static Face TopSouthEast = new Face(new Vertex[]{Vertex.TopNorthWest, Vertex.BottomSouthWest, Vertex.BottomNorthEast, Vertex.TopNorthWest});
    private static Face TopSouthWest = new Face(new Vertex[]{Vertex.TopNorthEast, Vertex.BottomNorthWest, Vertex.BottomSouthEast, Vertex.TopNorthEast});
    private static Face TopNorthWest = new Face(new Vertex[]{Vertex.TopSouthEast, Vertex.BottomNorthEast, Vertex.BottomSouthWest, Vertex.TopSouthEast});
    private static Face TopNorthEast = new Face(new Vertex[]{Vertex.TopSouthWest, Vertex.BottomSouthEast, Vertex.BottomNorthWest, Vertex.TopSouthWest});
    private static Face InvTopSouthEast = new Face(new Vertex[]{Vertex.TopSouthWest, Vertex.BottomSouthEast, Vertex.BottomSouthEast, Vertex.TopNorthEast});
    private static Face InvTopSouthWest = new Face(new Vertex[]{Vertex.TopNorthWest, Vertex.BottomSouthWest, Vertex.BottomSouthWest, Vertex.TopSouthEast});
    private static Face InvTopNorthWest = new Face(new Vertex[]{Vertex.TopNorthEast, Vertex.BottomNorthWest, Vertex.BottomNorthWest, Vertex.TopSouthWest});
    private static Face InvTopNorthEast = new Face(new Vertex[]{Vertex.TopSouthEast, Vertex.BottomNorthEast, Vertex.BottomNorthEast, Vertex.TopNorthWest});
    private static Face TriangleTopSouthWest = new Face(new Vertex[]{Vertex.TopSouthEast, Vertex.TopNorthEast, Vertex.TopNorthWest, Vertex.TopNorthWest});
    private static Face TriangleTopSouthEast = new Face(new Vertex[]{Vertex.TopNorthEast, Vertex.TopNorthWest, Vertex.TopSouthWest, Vertex.TopSouthWest});
    private static Face TriangleTopNorthWest = new Face(new Vertex[]{Vertex.TopSouthWest, Vertex.TopSouthEast, Vertex.TopNorthEast, Vertex.TopNorthEast});
    private static Face TriangleTopNorthEast = new Face(new Vertex[]{Vertex.TopNorthWest, Vertex.TopSouthWest, Vertex.TopSouthEast, Vertex.TopSouthEast});
    private static Face TriangleBottomSouthEast = new Face(new Vertex[]{Vertex.BottomSouthWest, Vertex.BottomNorthWest, Vertex.BottomNorthEast, Vertex.BottomNorthEast});
    private static Face TriangleBottomSouthWest = new Face(new Vertex[]{Vertex.BottomNorthWest, Vertex.BottomNorthEast, Vertex.BottomSouthEast, Vertex.BottomSouthEast});
    private static Face TriangleBottomNorthWest = new Face(new Vertex[]{Vertex.BottomNorthEast, Vertex.BottomSouthEast, Vertex.BottomSouthWest, Vertex.BottomSouthWest});
    private static Face TriangleBottomNorthEast = new Face(new Vertex[]{Vertex.BottomSouthEast, Vertex.BottomSouthWest, Vertex.BottomNorthWest, Vertex.BottomNorthWest});
    private static Face TriangleWestTopSouth = new Face(new Vertex[]{Vertex.TopNorthWest, Vertex.BottomNorthWest, Vertex.BottomSouthWest, Vertex.BottomSouthWest});
    private static Face TriangleEastTopSouth = new Face(new Vertex[]{Vertex.BottomSouthEast, Vertex.BottomNorthEast, Vertex.TopNorthEast, Vertex.TopNorthEast});
    private static Face TriangleWestTopNorth = new Face(new Vertex[]{Vertex.BottomNorthWest, Vertex.BottomSouthWest, Vertex.TopSouthWest, Vertex.TopSouthWest});
    private static Face TriangleEastTopNorth = new Face(new Vertex[]{Vertex.TopSouthEast, Vertex.BottomSouthEast, Vertex.BottomNorthEast, Vertex.BottomNorthEast});
    private static Face TriangleNorthTopWest = new Face(new Vertex[]{Vertex.TopNorthEast, Vertex.BottomNorthEast, Vertex.BottomNorthWest, Vertex.BottomNorthWest});
    private static Face TriangleSouthTopWest = new Face(new Vertex[]{Vertex.BottomSouthWest, Vertex.BottomSouthEast, Vertex.TopSouthEast, Vertex.TopSouthEast});
    private static Face TriangleNorthTopEast = new Face(new Vertex[]{Vertex.BottomNorthEast, Vertex.BottomNorthWest, Vertex.TopNorthWest, Vertex.TopNorthWest});
    private static Face TriangleSouthTopEast = new Face(new Vertex[]{Vertex.TopSouthWest, Vertex.BottomSouthWest, Vertex.BottomSouthEast, Vertex.BottomSouthEast});
    private static Face Gui = new Face(new Vertex[]{Vertex.BottomSouthWest, Vertex.TopSouthWest, Vertex.TopSouthEast, Vertex.BottomSouthEast});
    private static HashMap<String, int[]> aom = new HashMap();

    public static Face Bottom() {
        return new Face(Bottom);
    }

    public static Face Top() {
        return new Face(Top);
    }

    public static Face West() {
        return new Face(West);
    }

    public static Face North() {
        return new Face(North);
    }

    public static Face East() {
        return new Face(East);
    }

    public static Face South() {
        return new Face(South);
    }

    public static Face NorthWest() {
        return new Face(NorthWest);
    }

    public static Face NorthEast() {
        return new Face(NorthEast);
    }

    public static Face SouthWest() {
        return new Face(SouthWest);
    }

    public static Face SouthEast() {
        return new Face(SouthEast);
    }

    public static Face TopNorth() {
        return new Face(TopNorth);
    }

    public static Face TopEast() {
        return new Face(TopEast);
    }

    public static Face TopSouth() {
        return new Face(TopSouth);
    }

    public static Face TopWest() {
        return new Face(TopWest);
    }

    public static Face TopSouthEast() {
        return new Face(TopSouthEast);
    }

    public static Face TopSouthWest() {
        return new Face(TopSouthWest);
    }

    public static Face TopNorthWest() {
        return new Face(TopNorthWest);
    }

    public static Face TopNorthEast() {
        return new Face(TopNorthEast);
    }

    public static Face InvTopSouthEast() {
        return new Face(InvTopSouthEast);
    }

    public static Face InvTopSouthWest() {
        return new Face(InvTopSouthWest);
    }

    public static Face InvTopNorthWest() {
        return new Face(InvTopNorthWest);
    }

    public static Face InvTopNorthEast() {
        return new Face(InvTopNorthEast);
    }

    public static Face TriangleTopSouthWest() {
        return new Face(TriangleTopSouthWest);
    }

    public static Face TriangleTopSouthEast() {
        return new Face(TriangleTopSouthEast);
    }

    public static Face TriangleTopNorthWest() {
        return new Face(TriangleTopNorthWest);
    }

    public static Face TriangleTopNorthEast() {
        return new Face(TriangleTopNorthEast);
    }

    public static Face TriangleBottomSouthEast() {
        return new Face(TriangleBottomSouthEast);
    }

    public static Face TriangleBottomSouthWest() {
        return new Face(TriangleBottomSouthWest);
    }

    public static Face TriangleBottomNorthWest() {
        return new Face(TriangleBottomNorthWest);
    }

    public static Face TriangleBottomNorthEast() {
        return new Face(TriangleBottomNorthEast);
    }

    public static Face TriangleWestTopSouth() {
        return new Face(TriangleWestTopSouth);
    }

    public static Face TriangleEastTopSouth() {
        return new Face(TriangleEastTopSouth);
    }

    public static Face TriangleWestTopNorth() {
        return new Face(TriangleWestTopNorth);
    }

    public static Face TriangleEastTopNorth() {
        return new Face(TriangleEastTopNorth);
    }

    public static Face TriangleNorthTopWest() {
        return new Face(TriangleNorthTopWest);
    }

    public static Face TriangleSouthTopWest() {
        return new Face(TriangleSouthTopWest);
    }

    public static Face TriangleNorthTopEast() {
        return new Face(TriangleNorthTopEast);
    }

    public static Face TriangleSouthTopEast() {
        return new Face(TriangleSouthTopEast);
    }

    public static Face Gui() {
        return new Face(Gui);
    }

    public static int[] aom(String s) {
        int[] nArray;
        int[] a = aom.get(s);
        if (a == null) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray = nArray2;
            nArray2[2] = 0;
        } else {
            nArray = a;
        }
        return nArray;
    }

    private static void buildDirectionMatrix() {
        int[] a;
        for (int x : a = new int[]{-1, 0, 1}) {
            for (int y : a) {
                for (int z : a) {
                    aom.put(FacePreset.dirToString(x, y, z), new int[]{x, y, z});
                }
            }
        }
    }

    private static String dirToString(int x, int y, int z) {
        String s = "";
        s = s + (y == 0 ? "" : (y == 1 ? "Top" : "Bottom"));
        s = s + (z == 0 ? "" : (z == 1 ? "South" : "North"));
        s = s + (x == 0 ? "" : (x == 1 ? "East" : "West"));
        return s != "" ? s : "Center";
    }

    public static int[][][] calculateAoMatrix(Face face, ForgeDirection offset) {
        Vertex[] vertexes = face.getVertexes();
        int[][][] aoMatrix = new int[vertexes.length][3][3];
        for (int i = 0; i < vertexes.length; ++i) {
            aoMatrix[i] = FacePreset.vertexAoMatrix(vertexes[i], offset);
        }
        return aoMatrix;
    }

    private static int[][] vertexAoMatrix(Vertex vertex, ForgeDirection offset) {
        int[][] a = new int[3][3];
        if (offset == ForgeDirection.WEST || offset == ForgeDirection.EAST) {
            int n = offset.offsetX;
            a[2][0] = n;
            a[1][0] = n;
            a[0][0] = n;
            int[] nArray = a[1];
            nArray[1] = nArray[1] + (vertex.getIntY() * 2 - 1);
            int[] nArray2 = a[2];
            nArray2[1] = nArray2[1] + (vertex.getIntY() * 2 - 1);
            int[] nArray3 = a[0];
            nArray3[2] = nArray3[2] + (vertex.getIntZ() * 2 - 1);
            int[] nArray4 = a[1];
            nArray4[2] = nArray4[2] + (vertex.getIntZ() * 2 - 1);
        } else if (offset == ForgeDirection.UP || offset == ForgeDirection.DOWN) {
            int n = offset.offsetY;
            a[2][1] = n;
            a[1][1] = n;
            a[0][1] = n;
            int[] nArray = a[1];
            nArray[0] = nArray[0] + (vertex.getIntX() * 2 - 1);
            int[] nArray5 = a[2];
            nArray5[0] = nArray5[0] + (vertex.getIntX() * 2 - 1);
            int[] nArray6 = a[0];
            nArray6[2] = nArray6[2] + (vertex.getIntZ() * 2 - 1);
            int[] nArray7 = a[1];
            nArray7[2] = nArray7[2] + (vertex.getIntZ() * 2 - 1);
        } else if (offset == ForgeDirection.NORTH || offset == ForgeDirection.SOUTH) {
            int n = offset.offsetZ;
            a[2][2] = n;
            a[1][2] = n;
            a[0][2] = n;
            int[] nArray = a[1];
            nArray[0] = nArray[0] + (vertex.getIntX() * 2 - 1);
            int[] nArray8 = a[2];
            nArray8[0] = nArray8[0] + (vertex.getIntX() * 2 - 1);
            int[] nArray9 = a[0];
            nArray9[1] = nArray9[1] + (vertex.getIntY() * 2 - 1);
            int[] nArray10 = a[1];
            nArray10[1] = nArray10[1] + (vertex.getIntY() * 2 - 1);
        }
        return a;
    }

    public static Face fromDirection(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return FacePreset.Bottom();
            }
            case UP: {
                return FacePreset.Top();
            }
            case NORTH: {
                return FacePreset.North();
            }
            case SOUTH: {
                return FacePreset.South();
            }
            case WEST: {
                return FacePreset.West();
            }
            case EAST: {
                return FacePreset.East();
            }
        }
        return null;
    }

    static {
        FacePreset.buildDirectionMatrix();
        Gui.setStandardUV();
        RenderParameters rp = new RenderParameters();
        rp.direction.set(ForgeDirection.DOWN);
        rp.textureSide.set(ForgeDirection.DOWN);
        rp.colorFactor.set(Float.valueOf(0.5f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(Bottom, rp.direction.get()));
        Bottom.setParameters(rp);
        Bottom.setStandardUV();
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(1.0f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(Top, rp.direction.get()));
        Top.setParameters(rp);
        Top.setStandardUV();
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.WEST);
        rp.textureSide.set(ForgeDirection.WEST);
        rp.colorFactor.set(Float.valueOf(0.6f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(West, rp.direction.get()));
        West.setParameters(rp);
        West.setStandardUV();
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.NORTH);
        rp.textureSide.set(ForgeDirection.NORTH);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(North, rp.direction.get()));
        North.setParameters(rp);
        North.setStandardUV();
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.EAST);
        rp.textureSide.set(ForgeDirection.EAST);
        rp.colorFactor.set(Float.valueOf(0.6f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(East, rp.direction.get()));
        East.setParameters(rp);
        East.setStandardUV();
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.SOUTH);
        rp.textureSide.set(ForgeDirection.SOUTH);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(South, rp.direction.get()));
        South.setParameters(rp);
        South.setStandardUV();
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.NORTH);
        rp.textureSide.set(ForgeDirection.NORTH);
        rp.colorFactor.set(Float.valueOf(0.7f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("Top"), FacePreset.aom("TopEast"), FacePreset.aom("TopNorthEast"), FacePreset.aom("NorthEast")}, new int[][]{FacePreset.aom("Bottom"), FacePreset.aom("BottomEast"), FacePreset.aom("BottomNorthEast"), FacePreset.aom("NorthEast")}, new int[][]{FacePreset.aom("Bottom"), FacePreset.aom("BottomSouth"), FacePreset.aom("BottomSouthWest"), FacePreset.aom("SouthWest")}, new int[][]{FacePreset.aom("Top"), FacePreset.aom("TopSouth"), FacePreset.aom("TopSouthWest"), FacePreset.aom("SouthWest")}});
        NorthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.EAST);
        rp.textureSide.set(ForgeDirection.EAST);
        rp.colorFactor.set(Float.valueOf(0.7f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("Top"), FacePreset.aom("TopSouth"), FacePreset.aom("TopSouthEast"), FacePreset.aom("SouthEast")}, new int[][]{FacePreset.aom("Bottom"), FacePreset.aom("BottomSouth"), FacePreset.aom("BottomSouthEast"), FacePreset.aom("SouthEast")}, new int[][]{FacePreset.aom("Bottom"), FacePreset.aom("BottomWest"), FacePreset.aom("BottomNorthWest"), FacePreset.aom("NorthWest")}, new int[][]{FacePreset.aom("Top"), FacePreset.aom("TopWest"), FacePreset.aom("TopNorthWest"), FacePreset.aom("NorthWest")}});
        NorthEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.WEST);
        rp.textureSide.set(ForgeDirection.WEST);
        rp.colorFactor.set(Float.valueOf(0.7f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("Top"), FacePreset.aom("TopNorth"), FacePreset.aom("TopNorthWest"), FacePreset.aom("NorthWest")}, new int[][]{FacePreset.aom("Bottom"), FacePreset.aom("BottomNorth"), FacePreset.aom("BottomNorthWest"), FacePreset.aom("NorthWest")}, new int[][]{FacePreset.aom("Bottom"), FacePreset.aom("BottomEast"), FacePreset.aom("BottomSouthEast"), FacePreset.aom("SouthEast")}, new int[][]{FacePreset.aom("Top"), FacePreset.aom("TopEast"), FacePreset.aom("TopSouthEast"), FacePreset.aom("SouthEast")}});
        SouthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.SOUTH);
        rp.textureSide.set(ForgeDirection.SOUTH);
        rp.colorFactor.set(Float.valueOf(0.7f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("Top"), FacePreset.aom("TopWest"), FacePreset.aom("TopSouthWest"), FacePreset.aom("SouthWest")}, new int[][]{FacePreset.aom("Bottom"), FacePreset.aom("BottomWest"), FacePreset.aom("BottomSouthWest"), FacePreset.aom("SouthWest")}, new int[][]{FacePreset.aom("Bottom"), FacePreset.aom("BottomNorth"), FacePreset.aom("BottomNorthEast"), FacePreset.aom("NorthEast")}, new int[][]{FacePreset.aom("Top"), FacePreset.aom("TopNorth"), FacePreset.aom("TopNortEastWest"), FacePreset.aom("NorthEast")}});
        SouthEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.9f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopSouth"), FacePreset.aom("TopSouthEast"), FacePreset.aom("TopEast"), FacePreset.aom("East")}, new int[][]{FacePreset.aom("East"), FacePreset.aom("NorthEast"), FacePreset.aom("BottomNorthEast"), FacePreset.aom("BottomNorth")}, new int[][]{FacePreset.aom("BottomNorth"), FacePreset.aom("BottomNorthWest"), FacePreset.aom("NorthWest"), FacePreset.aom("West")}, new int[][]{FacePreset.aom("West"), FacePreset.aom("TopWest"), FacePreset.aom("TopSouthWest"), FacePreset.aom("TopSouth")}});
        TopNorth.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopWest"), FacePreset.aom("TopSouthWest"), FacePreset.aom("TopSouth"), FacePreset.aom("South")}, new int[][]{FacePreset.aom("South"), FacePreset.aom("SouthEast"), FacePreset.aom("BottomSouthEast"), FacePreset.aom("BottomEast")}, new int[][]{FacePreset.aom("BottomEast"), FacePreset.aom("BottomNorthEast"), FacePreset.aom("NorthEast"), FacePreset.aom("East")}, new int[][]{FacePreset.aom("North"), FacePreset.aom("TopNorth"), FacePreset.aom("TopNorthWest"), FacePreset.aom("TopWest")}});
        TopEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.9f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopNorth"), FacePreset.aom("TopNorthWest"), FacePreset.aom("TopWest"), FacePreset.aom("West")}, new int[][]{FacePreset.aom("West"), FacePreset.aom("SouthWest"), FacePreset.aom("BottomSouthWest"), FacePreset.aom("BottomSouth")}, new int[][]{FacePreset.aom("BottomSouth"), FacePreset.aom("BottomSouthEast"), FacePreset.aom("SouthEast"), FacePreset.aom("East")}, new int[][]{FacePreset.aom("East"), FacePreset.aom("TopEast"), FacePreset.aom("TopNorthEast"), FacePreset.aom("TopNorth")}});
        TopSouth.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopEast"), FacePreset.aom("TopNorthEast"), FacePreset.aom("TopNorth"), FacePreset.aom("North")}, new int[][]{FacePreset.aom("North"), FacePreset.aom("NorthWest"), FacePreset.aom("BottomNorthWest"), FacePreset.aom("BottomWest")}, new int[][]{FacePreset.aom("BottomWest"), FacePreset.aom("BottomSouthWest"), FacePreset.aom("SouthWest"), FacePreset.aom("South")}, new int[][]{FacePreset.aom("South"), FacePreset.aom("TopSouth"), FacePreset.aom("TopSouthEast"), FacePreset.aom("TopEast")}});
        TopWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopNorthWest"), FacePreset.aom("TopNorth"), FacePreset.aom("TopWest")}, new int[][]{FacePreset.aom("West"), FacePreset.aom("SouthWest"), FacePreset.aom("Bottom"), FacePreset.aom("BottomSouth")}, new int[][]{FacePreset.aom("North"), FacePreset.aom("NorthEast"), FacePreset.aom("Bottom"), FacePreset.aom("BottomEast")}, new int[][]{FacePreset.aom("TopNorthWest"), FacePreset.aom("TopNorth"), FacePreset.aom("TopWest")}});
        TopSouthEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopNorthEast"), FacePreset.aom("TopNorth"), FacePreset.aom("TopEast")}, new int[][]{FacePreset.aom("North"), FacePreset.aom("NorthWest"), FacePreset.aom("Bottom"), FacePreset.aom("BottomWest")}, new int[][]{FacePreset.aom("East"), FacePreset.aom("SouthEast"), FacePreset.aom("Bottom"), FacePreset.aom("BottomSouth")}, new int[][]{FacePreset.aom("TopNorthEast"), FacePreset.aom("TopNorth"), FacePreset.aom("TopEast")}});
        TopSouthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopSouthEast"), FacePreset.aom("TopSouth"), FacePreset.aom("TopEast")}, new int[][]{FacePreset.aom("West"), FacePreset.aom("NorthWest"), FacePreset.aom("Bottom"), FacePreset.aom("BottomNorth")}, new int[][]{FacePreset.aom("South"), FacePreset.aom("SouthWest"), FacePreset.aom("Bottom"), FacePreset.aom("BottomWest")}, new int[][]{FacePreset.aom("TopSouthEast"), FacePreset.aom("TopSouth"), FacePreset.aom("TopEast")}});
        TopNorthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopSouthWest"), FacePreset.aom("TopSouth"), FacePreset.aom("TopWest")}, new int[][]{FacePreset.aom("South"), FacePreset.aom("SouthEast"), FacePreset.aom("Bottom"), FacePreset.aom("BottomEast")}, new int[][]{FacePreset.aom("West"), FacePreset.aom("NorthWest"), FacePreset.aom("Bottom"), FacePreset.aom("BottomNorth")}, new int[][]{FacePreset.aom("TopSouthWest"), FacePreset.aom("TopSouth"), FacePreset.aom("TopWest")}});
        TopNorthEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopWest"), FacePreset.aom("TopSouthWest"), FacePreset.aom("TopSouth"), FacePreset.aom("South")}, new int[][]{FacePreset.aom("BottomSouth"), FacePreset.aom("SouthEast"), FacePreset.aom("BottomEast")}, new int[][]{FacePreset.aom("BottomSouth"), FacePreset.aom("SouthEast"), FacePreset.aom("BottomEast")}, new int[][]{FacePreset.aom("TopNorth"), FacePreset.aom("TopNorthEast"), FacePreset.aom("TopEast"), FacePreset.aom("East")}});
        InvTopSouthEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopNorth"), FacePreset.aom("TopNorthWest"), FacePreset.aom("TopWest"), FacePreset.aom("West")}, new int[][]{FacePreset.aom("BottomSouth"), FacePreset.aom("SouthWest"), FacePreset.aom("BottomWest")}, new int[][]{FacePreset.aom("BottomSouth"), FacePreset.aom("SouthWest"), FacePreset.aom("BottomWest")}, new int[][]{FacePreset.aom("TopEast"), FacePreset.aom("TopSouthEast"), FacePreset.aom("TopSouth"), FacePreset.aom("South")}});
        InvTopSouthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopWest"), FacePreset.aom("TopNorthWest"), FacePreset.aom("East")}, new int[][]{FacePreset.aom("BottomNorth"), FacePreset.aom("NorthWest"), FacePreset.aom("BottomWest")}, new int[][]{FacePreset.aom("BottomNorth"), FacePreset.aom("NorthWest"), FacePreset.aom("BottomWest")}, new int[][]{FacePreset.aom("TopSouth"), FacePreset.aom("TopSouthWest"), FacePreset.aom("West")}});
        InvTopNorthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(new int[][][]{new int[][]{FacePreset.aom("TopSouth"), FacePreset.aom("TopSouthEast"), FacePreset.aom("East")}, new int[][]{FacePreset.aom("BottomWest"), FacePreset.aom("BottomNortWest"), FacePreset.aom("BottomNorth")}, new int[][]{FacePreset.aom("BottomWest"), FacePreset.aom("BottomNortWest"), FacePreset.aom("BottomNorth")}, new int[][]{FacePreset.aom("TopWest"), FacePreset.aom("TopNorthWest"), FacePreset.aom("North")}});
        InvTopNorthEast.setParameters(rp);
        rp = new RenderParameters();
        rp.textureSide.set(ForgeDirection.UP);
        rp.direction.set(ForgeDirection.WEST);
        rp.colorFactor.set(Float.valueOf(0.6f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(South, rp.direction.get()));
        TriangleWestTopSouth.setParameters(rp);
        rp = new RenderParameters();
        rp.textureSide.set(ForgeDirection.UP);
        rp.direction.set(ForgeDirection.EAST);
        rp.colorFactor.set(Float.valueOf(0.6f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(South, rp.direction.get()));
        TriangleEastTopSouth.setParameters(rp);
        rp = new RenderParameters();
        rp.textureSide.set(ForgeDirection.UP);
        rp.direction.set(ForgeDirection.WEST);
        rp.colorFactor.set(Float.valueOf(0.6f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(South, rp.direction.get()));
        TriangleWestTopNorth.setParameters(rp);
        rp = new RenderParameters();
        rp.textureSide.set(ForgeDirection.UP);
        rp.direction.set(ForgeDirection.EAST);
        rp.colorFactor.set(Float.valueOf(0.6f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(South, rp.direction.get()));
        TriangleEastTopNorth.setParameters(rp);
        rp = new RenderParameters();
        rp.textureSide.set(ForgeDirection.UP);
        rp.direction.set(ForgeDirection.NORTH);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(South, rp.direction.get()));
        TriangleNorthTopWest.setParameters(rp);
        rp = new RenderParameters();
        rp.textureSide.set(ForgeDirection.UP);
        rp.direction.set(ForgeDirection.SOUTH);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(South, rp.direction.get()));
        TriangleSouthTopWest.setParameters(rp);
        rp = new RenderParameters();
        rp.textureSide.set(ForgeDirection.UP);
        rp.direction.set(ForgeDirection.NORTH);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(South, rp.direction.get()));
        TriangleNorthTopEast.setParameters(rp);
        rp = new RenderParameters();
        rp.textureSide.set(ForgeDirection.UP);
        rp.direction.set(ForgeDirection.SOUTH);
        rp.colorFactor.set(Float.valueOf(0.8f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(South, rp.direction.get()));
        TriangleSouthTopEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(TriangleTopSouthWest, rp.direction.get()));
        TriangleTopSouthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(TriangleTopSouthEast, rp.direction.get()));
        TriangleTopSouthEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(TriangleTopNorthWest, rp.direction.get()));
        TriangleTopNorthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.UP);
        rp.textureSide.set(ForgeDirection.UP);
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(TriangleTopNorthEast, rp.direction.get()));
        TriangleTopNorthEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.DOWN);
        rp.textureSide.set(ForgeDirection.DOWN);
        rp.colorFactor.set(Float.valueOf(0.5f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(TriangleBottomSouthEast, rp.direction.get()));
        TriangleBottomSouthEast.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.DOWN);
        rp.textureSide.set(ForgeDirection.DOWN);
        rp.colorFactor.set(Float.valueOf(0.5f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(TriangleBottomSouthWest, rp.direction.get()));
        TriangleBottomSouthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.DOWN);
        rp.textureSide.set(ForgeDirection.DOWN);
        rp.colorFactor.set(Float.valueOf(0.5f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(TriangleBottomNorthWest, rp.direction.get()));
        TriangleBottomNorthWest.setParameters(rp);
        rp = new RenderParameters();
        rp.direction.set(ForgeDirection.DOWN);
        rp.textureSide.set(ForgeDirection.DOWN);
        rp.colorFactor.set(Float.valueOf(0.5f));
        rp.aoMatrix.set(FacePreset.calculateAoMatrix(TriangleBottomNorthEast, rp.direction.get()));
        TriangleBottomNorthEast.setParameters(rp);
    }
}

