/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door;

import java.util.HashMap;
import java.util.List;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.block.MixedBlock;
import net.malisis.doors.door.Door;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorItem;
import net.malisis.doors.door.tileentity.CustomDoorTileEntity;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.malisis.doors.entity.DoorFactoryTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CustomDoorItem
extends DoorItem {
    private static HashMap<Item, Block> itemsAllowed = new HashMap();

    public CustomDoorItem() {
        this.func_77655_b("custom_door");
        this.field_77777_bU = 16;
        this.func_77637_a(null);
    }

    @Override
    public DoorDescriptor getDescriptor(ItemStack itemStack) {
        return new DoorDescriptor(itemStack.field_77990_d);
    }

    @Override
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    @Override
    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        DoorTileEntity te;
        boolean b = super.func_77648_a(itemStack, player, world, x, y, z, side, par8, par9, par10);
        if (b && (te = Door.getDoor((IBlockAccess)world, x, y + 1, z)) instanceof CustomDoorTileEntity) {
            ((CustomDoorTileEntity)te).onBlockPlaced(itemStack);
        }
        return b;
    }

    public static ItemStack fromDoorFactory(DoorFactoryTileEntity te) {
        if (te.getDoorMovement() == null || te.getDoorSound() == null) {
            return null;
        }
        ItemStack frameItemStack = te.frameSlot.getItemStack();
        ItemStack topMaterialItemStack = te.topMaterialSlot.getItemStack();
        ItemStack bottomMaterialItemStack = te.bottomMaterialSlot.getItemStack();
        if (!(CustomDoorItem.canBeUsedForDoor(frameItemStack, true) && CustomDoorItem.canBeUsedForDoor(topMaterialItemStack, false) && CustomDoorItem.canBeUsedForDoor(bottomMaterialItemStack, false))) {
            return null;
        }
        Block frameBlock = Block.func_149634_a((Item)frameItemStack.func_77973_b());
        int frameMetadata = ((ItemBlock)frameItemStack.func_77973_b()).func_77647_b(frameItemStack.func_77960_j());
        Block topMaterialBlock = itemsAllowed.get(topMaterialItemStack.func_77973_b());
        if (topMaterialBlock == null) {
            topMaterialBlock = Block.func_149634_a((Item)topMaterialItemStack.func_77973_b());
        }
        int topMaterialMetadata = topMaterialItemStack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)topMaterialItemStack.func_77973_b()).func_77647_b(topMaterialItemStack.func_77960_j()) : topMaterialItemStack.func_77960_j();
        Block bottomMaterialBlock = itemsAllowed.get(bottomMaterialItemStack.func_77973_b());
        if (bottomMaterialBlock == null) {
            bottomMaterialBlock = Block.func_149634_a((Item)bottomMaterialItemStack.func_77973_b());
        }
        int bottomMaterialMetadata = bottomMaterialItemStack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)bottomMaterialItemStack.func_77973_b()).func_77647_b(bottomMaterialItemStack.func_77960_j()) : bottomMaterialItemStack.func_77960_j();
        NBTTagCompound nbt = new NBTTagCompound();
        DoorDescriptor desc = new DoorDescriptor();
        desc.set(MalisisDoors.Blocks.customDoor, MalisisDoors.Items.customDoorItem);
        desc.setMovement(te.getDoorMovement());
        desc.setSound(te.getDoorSound());
        desc.setOpeningTime(te.getOpeningTime());
        desc.setRequireRedstone(te.requireRedstone());
        desc.setDoubleDoor(te.isDoubleDoor());
        desc.writeNBT(nbt);
        nbt.func_74768_a("frame", Block.func_149682_b((Block)frameBlock));
        nbt.func_74768_a("topMaterial", Block.func_149682_b((Block)topMaterialBlock));
        nbt.func_74768_a("bottomMaterial", Block.func_149682_b((Block)bottomMaterialBlock));
        nbt.func_74768_a("frameMetadata", frameMetadata);
        nbt.func_74768_a("topMaterialMetadata", topMaterialMetadata);
        nbt.func_74768_a("bottomMaterialMetadata", bottomMaterialMetadata);
        ItemStack is = new ItemStack(MalisisDoors.Items.customDoorItem, 1);
        is.field_77990_d = nbt;
        return is;
    }

    public static ItemStack fromTileEntity(CustomDoorTileEntity te) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (te.getDescriptor() != null) {
            te.getDescriptor().writeNBT(nbt);
        }
        nbt.func_74768_a("frame", Block.func_149682_b((Block)te.getFrame()));
        nbt.func_74768_a("topMaterial", Block.func_149682_b((Block)te.getTopMaterial()));
        nbt.func_74768_a("bottomMaterial", Block.func_149682_b((Block)te.getBottomMaterial()));
        nbt.func_74768_a("frameMetadata", te.getFrameMetadata());
        nbt.func_74768_a("topMaterialMetadata", te.getTopMaterialMetadata());
        nbt.func_74768_a("bottomMaterialMetadata", te.getBottomMaterialMetadata());
        ItemStack is = new ItemStack(MalisisDoors.Items.customDoorItem, 1);
        is.field_77990_d = nbt;
        return is;
    }

    public static boolean canBeUsedForDoor(ItemStack itemStack, boolean frame) {
        if (!frame && itemsAllowed.get(itemStack.func_77973_b()) != null) {
            return true;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        return !(block instanceof MixedBlock) && block.func_149645_b() != -1;
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        return super.func_77653_i(par1ItemStack);
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean advancedTooltip) {
        Block frame = Block.func_149729_e((int)itemStack.field_77990_d.func_74762_e("frame"));
        int frameMetadata = itemStack.field_77990_d.func_74762_e("frameMetadata");
        ItemStack isFrame = new ItemStack(frame, 0, frameMetadata);
        Block topMaterial = Block.func_149729_e((int)itemStack.field_77990_d.func_74762_e("topMaterial"));
        int topMaterialMetadata = itemStack.field_77990_d.func_74762_e("topMaterialMetadata");
        ItemStack istopMaterial = new ItemStack(topMaterial, 0, topMaterialMetadata);
        Block bottomMaterial = Block.func_149729_e((int)itemStack.field_77990_d.func_74762_e("bottomMaterial"));
        int bottomMaterialMetadata = itemStack.field_77990_d.func_74762_e("bottomMaterialMetadata");
        ItemStack isBottomMaterial = new ItemStack(bottomMaterial, 0, bottomMaterialMetadata);
        list.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)("door_movement." + itemStack.field_77990_d.func_74779_i("movement"))));
        list.addAll(isFrame.func_82840_a(player, advancedTooltip));
        list.addAll(istopMaterial.func_82840_a(player, advancedTooltip));
        list.addAll(isBottomMaterial.func_82840_a(player, advancedTooltip));
    }

    static {
        itemsAllowed.put(Items.field_151033_d, (Block)Blocks.field_150480_ab);
        itemsAllowed.put(Items.field_151079_bi, (Block)Blocks.field_150427_aO);
        itemsAllowed.put(Items.field_151131_as, Blocks.field_150355_j);
        itemsAllowed.put(Items.field_151129_at, Blocks.field_150353_l);
    }
}

