/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class RotateAndSlideMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity te, boolean topBlock, boolean selBox) {
        int dir = te.getDirection();
        boolean opened = te.isOpened();
        boolean reversed = te.isReversed();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (dir == 1 && !opened || dir == 0 && opened && !reversed || dir == 2 && opened && reversed) {
            Z = 0.1875f;
        } else if (dir == 0 && !opened || dir == 3 && opened && !reversed || dir == 1 && opened && reversed) {
            X = 0.1875f;
        } else if (dir == 2 && !opened || dir == 1 && opened && !reversed || dir == 3 && opened && reversed) {
            x = 0.8125f;
        } else if (dir == 3 && !opened || dir == 2 && opened && !reversed || dir == 0 && opened && reversed) {
            z = 0.8125f;
        }
        if (selBox) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    @Override
    public Transformation getTopTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity);
    }

    @Override
    public Transformation getBottomTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity) {
        int ot = tileEntity.getDescriptor().getOpeningTime() / 2;
        float angle = -90.0f;
        float hinge = 0.40625f;
        float hingeZ = -0.40625f;
        float tr = 0.8125f;
        if (tileEntity.isReversed()) {
            hinge = -hinge;
            angle = -angle;
            tr = -tr;
        }
        Transformation rotation = new Rotation(angle).aroundAxis(0.0f, 1.0f, 0.0f).offset(hinge, 0.0f, hingeZ).forTicks(ot);
        Transformation translation = new Translation(tr, 0.0f, 0.0f).forTicks(ot);
        ChainedTransformation transformation = new ChainedTransformation(new Transformation[]{rotation, translation});
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            transformation.reversed(true);
        }
        return transformation;
    }
}

