/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TrapDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, boolean selBox) {
        int dir = tileEntity.getDirection();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (!tileEntity.isOpened()) {
            if (topBlock) {
                y = 0.8125f;
            } else {
                Y = 0.1875f;
            }
        } else {
            if (dir == 1) {
                Z = 0.1875f;
            }
            if (dir == 0) {
                z = 0.8125f;
            }
            if (dir == 2) {
                x = 0.8125f;
            }
            if (dir == 3) {
                X = 0.1875f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    @Override
    public Transformation getTopTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity, true);
    }

    @Override
    public Transformation getBottomTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity, false);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float f = 0.40625f;
        float fromAngle = 0.0f;
        float toAngle = 90.0f;
        if (topBlock) {
            toAngle = -toAngle;
        }
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            float tmp = toAngle;
            toAngle = fromAngle;
            fromAngle = tmp;
        }
        return new Rotation(fromAngle, toAngle).aroundAxis(1.0f, 0.0f, 0.0f).offset(0.0f, -f, f).forTicks(tileEntity.getDescriptor().getOpeningTime());
    }
}

