/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.door.CustomDoorItem;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.sound.IDoorSound;
import net.malisis.doors.gui.DoorFactoryGui;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class DoorFactoryTileEntity
extends TileEntity
implements IInventoryProvider {
    private MalisisInventory inventory;
    private IDoorMovement doorMovement;
    private IDoorSound doorSound;
    private int openingTime = 6;
    private boolean requireRedstone = false;
    private boolean doubleDoor = true;
    public MalisisSlot frameSlot = new DoorFactorySlot(0);
    public MalisisSlot topMaterialSlot = new DoorFactorySlot(1);
    public MalisisSlot bottomMaterialSlot = new DoorFactorySlot(2);
    public MalisisSlot outputSlot = new MalisisSlot(3);

    public DoorFactoryTileEntity() {
        this.outputSlot.setOutputSlot(true);
        this.inventory = new MalisisInventory((IInventoryProvider)this, new MalisisSlot[]{this.frameSlot, this.topMaterialSlot, this.bottomMaterialSlot, this.outputSlot});
    }

    public IDoorMovement getDoorMovement() {
        return this.doorMovement;
    }

    public void setDoorMovement(IDoorMovement doorMovement) {
        this.doorMovement = doorMovement;
    }

    public IDoorSound getDoorSound() {
        return this.doorSound;
    }

    public void setDoorSound(IDoorSound doorSound) {
        this.doorSound = doorSound;
    }

    public int getOpeningTime() {
        return this.openingTime;
    }

    public void setOpeningTime(int openingTime) {
        this.openingTime = openingTime;
    }

    public boolean requireRedstone() {
        return this.requireRedstone;
    }

    public void setRequireRedstone(boolean requireRedstone) {
        this.requireRedstone = requireRedstone;
    }

    public boolean isDoubleDoor() {
        return this.doubleDoor;
    }

    public void setDoubleDoor(boolean doubleDoor) {
        this.doubleDoor = doubleDoor;
    }

    public void createDoor() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.canCreateDoor()) {
            return;
        }
        ItemStack expected = CustomDoorItem.fromDoorFactory(this);
        ItemStack output = this.outputSlot.getItemStack();
        if (expected == null) {
            return;
        }
        if (!(output == null || ItemStack.func_77970_a((ItemStack)output, (ItemStack)expected) && output.field_77994_a < output.func_77976_d())) {
            return;
        }
        this.frameSlot.addItemStackSize(-1);
        this.topMaterialSlot.addItemStackSize(-1);
        this.bottomMaterialSlot.addItemStackSize(-1);
        if (output == null) {
            this.outputSlot.setItemStack(expected);
        } else {
            this.outputSlot.addItemStackSize(1);
        }
    }

    public boolean canCreateDoor() {
        if (this.doorMovement == null || this.doorSound == null || this.openingTime == 0) {
            return false;
        }
        if (this.frameSlot.getItemStack() == null) {
            return false;
        }
        if (this.topMaterialSlot.getItemStack() == null) {
            return false;
        }
        return this.bottomMaterialSlot.getItemStack() != null;
    }

    public MalisisInventory getInventory() {
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public MalisisGui getGui(MalisisInventoryContainer container) {
        return new DoorFactoryGui(this, container);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.doorMovement != null) {
            nbt.func_74778_a("doorMovement", DoorRegistry.getId(this.doorMovement));
        }
        if (this.doorSound != null) {
            nbt.func_74778_a("doorSound", DoorRegistry.getId(this.doorSound));
        }
        nbt.func_74768_a("openingTime", this.openingTime);
        nbt.func_74757_a("requireRedstone", this.requireRedstone);
        nbt.func_74757_a("doubleDoor", this.doubleDoor);
        this.inventory.writeToNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.doorMovement = DoorRegistry.getMovement(nbt.func_74779_i("doorMovement"));
        this.doorSound = DoorRegistry.getSound(nbt.func_74779_i("doorSound"));
        this.openingTime = nbt.func_74762_e("openingTime");
        this.requireRedstone = nbt.func_74767_n("requireRedstone");
        this.doubleDoor = nbt.func_74767_n("doubleDoor");
        this.inventory.readFromNBT(nbt);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        TileEntityUtils.updateGui((TileEntity)this);
    }

    private class DoorFactorySlot
    extends MalisisSlot {
        public DoorFactorySlot(int index) {
            super(index);
        }

        public boolean isItemValid(ItemStack itemStack) {
            return !this.isOutputSlot && CustomDoorItem.canBeUsedForDoor(itemStack, this.slotNumber == 0);
        }
    }
}

