/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.gui;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.UISlot;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UIPanel;
import net.malisis.core.client.gui.component.container.UIPlayerInventory;
import net.malisis.core.client.gui.component.container.UITabGroup;
import net.malisis.core.client.gui.component.container.UIWindow;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.client.gui.component.interaction.UISelect;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.sound.IDoorSound;
import net.malisis.doors.entity.DoorFactoryTileEntity;
import net.malisis.doors.network.DoorFactoryMessage;
import net.minecraft.tileentity.TileEntity;

public class DoorFactoryGui
extends MalisisGui {
    private DoorFactoryTileEntity tileEntity;
    private UISelect selDoorMovement;
    private UITextField tfOpenTime;
    private UICheckBox cbRedstone;
    private UICheckBox cbDoubleDoor;
    private UISelect selDoorSound;

    public DoorFactoryGui(DoorFactoryTileEntity te, MalisisInventoryContainer container) {
        this.setInventoryContainer(container);
        this.tileEntity = te;
        UIWindow window = new UIWindow("tile.door_factory.name", 190, 240);
        UIPanel propContainer = (UIPanel)new UIPanel(180, 70).setPosition(0, 25);
        UIPanel matContainer = (UIPanel)new UIPanel(180, 70).setPosition(0, 25);
        UITabGroup tabGroup = (UITabGroup)new UITabGroup().setPosition(0, 13);
        tabGroup.addTab("gui.door_factory.tab_properties", (UIContainer)propContainer);
        tabGroup.addTab("gui.door_factory.tab_materials", (UIContainer)matContainer);
        this.setPropertiesContainer((UIContainer)propContainer);
        this.setMaterialsContainer((UIContainer)matContainer);
        UIButton btnCreate = (UIButton)((UIButton)new UIButton("gui.door_factory.create_door", 80).setPosition(50, 100)).register((Object)this);
        UISlot outputSlot = (UISlot)new UISlot(this.tileEntity.outputSlot).setPosition(81, 122);
        UIPlayerInventory playerInv = new UIPlayerInventory(container.getPlayerInventory());
        window.add((UIComponent)playerInv);
        window.add((UIComponent)tabGroup);
        window.add((UIComponent)propContainer);
        window.add((UIComponent)matContainer);
        window.add((UIComponent)btnCreate);
        window.add((UIComponent)outputSlot);
        this.addToScreen((UIContainer)window);
        TileEntityUtils.linkTileEntityToGui((TileEntity)this.tileEntity, (MalisisGui)this);
    }

    private void setPropertiesContainer(UIContainer propContainer) {
        HashMap<IDoorMovement, String> listMvt = new HashMap<IDoorMovement, String>();
        for (Map.Entry<String, IDoorMovement> entry : DoorRegistry.listMovements().entrySet()) {
            listMvt.put(entry.getValue(), entry.getKey());
        }
        this.selDoorMovement = (UISelect)((UISelect)new UISelect(100, UISelect.Option.fromList(listMvt)).setPosition(0, 2, Anchor.RIGHT)).register((Object)this);
        this.selDoorMovement.setLabelPattern("door_movement.%s");
        this.tfOpenTime = (UITextField)((UITextField)new UITextField(30).setPosition(-5, 14, Anchor.RIGHT)).setFilter("\\d+").register((Object)this);
        this.cbRedstone = (UICheckBox)((UICheckBox)new UICheckBox().setPosition(-15, 26, Anchor.RIGHT)).register((Object)this);
        this.cbDoubleDoor = (UICheckBox)((UICheckBox)new UICheckBox().setPosition(-15, 38, Anchor.RIGHT)).register((Object)this);
        HashMap<IDoorSound, String> listSounds = new HashMap<IDoorSound, String>();
        for (Map.Entry<String, IDoorSound> entry : DoorRegistry.listSounds().entrySet()) {
            listSounds.put(entry.getValue(), entry.getKey());
        }
        this.selDoorSound = (UISelect)((UISelect)new UISelect(100, UISelect.Option.fromList(listSounds)).setPosition(0, 50, Anchor.RIGHT)).register((Object)this);
        this.selDoorSound.setLabelPattern("gui.door_factory.door_sound.%s");
        propContainer.add(new UILabel("gui.door_factory.door_movement").setPosition(0, 4));
        propContainer.add(new UILabel("gui.door_factory.door_open_time").setPosition(0, 16));
        propContainer.add(new UILabel("gui.door_factory.door_require_redstone").setPosition(0, 28));
        propContainer.add(new UILabel("gui.door_factory.door_double_door").setPosition(0, 40));
        propContainer.add(new UILabel("gui.door_factory.door_sound").setPosition(0, 52));
        propContainer.add((UIComponent)this.selDoorMovement);
        propContainer.add((UIComponent)this.tfOpenTime);
        propContainer.add((UIComponent)this.cbRedstone);
        propContainer.add((UIComponent)this.cbDoubleDoor);
        propContainer.add((UIComponent)this.selDoorSound);
    }

    private void setMaterialsContainer(UIContainer matContainer) {
        UISlot frameSlot = (UISlot)new UISlot(this.tileEntity.frameSlot).setPosition(-10, 4, Anchor.RIGHT);
        UISlot topMaterialSlot = (UISlot)new UISlot(this.tileEntity.topMaterialSlot).setPosition(-10, 24, Anchor.RIGHT);
        UISlot bottomMaterialSlot = (UISlot)new UISlot(this.tileEntity.bottomMaterialSlot).setPosition(-10, 44, Anchor.RIGHT);
        matContainer.add(new UILabel("gui.door_factory.frame_type").setPosition(0, 9));
        matContainer.add(new UILabel("gui.door_factory.top_material").setPosition(0, 29));
        matContainer.add(new UILabel("gui.door_factory.bottom_material").setPosition(0, 49));
        matContainer.add((UIComponent)frameSlot);
        matContainer.add((UIComponent)topMaterialSlot);
        matContainer.add((UIComponent)bottomMaterialSlot);
    }

    public void updateGui() {
        this.selDoorMovement.setSelectedOption((Object)this.tileEntity.getDoorMovement());
        this.tfOpenTime.setText(Integer.toString(this.tileEntity.getOpeningTime()));
        this.cbRedstone.setChecked(this.tileEntity.requireRedstone());
        this.cbDoubleDoor.setChecked(this.tileEntity.isDoubleDoor());
        this.selDoorSound.setSelectedOption((Object)this.tileEntity.getDoorSound());
    }

    @Subscribe
    public void onGuiChangeEvent(ComponentEvent<UIComponent> event) {
        if (event instanceof ComponentEvent.StateChanged) {
            return;
        }
        UISelect.Option opt = this.selDoorMovement.getSelectedOption();
        if (opt != null) {
            this.tileEntity.setDoorMovement((IDoorMovement)opt.getKey());
        }
        try {
            this.tileEntity.setOpeningTime(Integer.parseInt(this.tfOpenTime.getText()));
        }
        catch (NumberFormatException e) {
            this.tfOpenTime.setText(Integer.toString(this.tileEntity.getOpeningTime()));
        }
        this.tileEntity.setRequireRedstone(this.cbRedstone.isChecked());
        this.tileEntity.setDoubleDoor(this.cbDoubleDoor.isChecked());
        opt = this.selDoorSound.getSelectedOption();
        if (opt != null) {
            this.tileEntity.setDoorSound((IDoorSound)opt.getKey());
        }
        DoorFactoryMessage.sendDoorInformations(this.tileEntity);
    }

    @Subscribe
    public void onCreateDoor(UIButton.ClickedEvent event) {
        DoorFactoryMessage.sendCreateDoor(this.tileEntity);
    }
}

