/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.tileentity;

import dk.mrspring.kitchen.KitchenItems;
import dk.mrspring.kitchen.OvenRecipes;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityOven
extends TileEntity {
    protected ItemStack[] ovenItems = new ItemStack[4];
    protected int burnTime = 0;
    protected int itemState = 0;
    protected boolean isCooking = false;
    public static final int RAW = 0;
    public static final int COOKED = 1;
    public static final int BURNT = 2;
    protected boolean isOpen = false;
    protected boolean hasCoal = false;
    protected float lidAngle = 0.0f;

    public boolean addItemStack(ItemStack itemStack) {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (itemStack != null) {
            if (itemStack.func_77973_b() != null) {
                if (FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null && FurnaceRecipes.func_77602_a().func_151395_a(itemStack).func_77973_b() instanceof ItemFood) {
                    return this.forceAddItemStack(itemStack);
                }
                if (OvenRecipes.getCookingResult(itemStack) != null) {
                    return this.forceAddItemStack(itemStack);
                }
                if (itemStack.func_77973_b() == Items.field_151044_h) {
                    return this.forceAddItemStack(itemStack);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean forceAddItemStack(ItemStack itemStack) {
        ItemStack temp = itemStack.func_77946_l();
        temp.field_77994_a = 1;
        if (itemStack.func_77973_b() == Items.field_151044_h && !this.hasCoal) {
            this.hasCoal = true;
            --itemStack.field_77994_a;
            return true;
        }
        for (int i = 0; i < this.ovenItems.length; ++i) {
            if (this.ovenItems[i] != null) {
                if (!itemStack.func_77969_a(this.ovenItems[i]) || this.ovenItems[i].field_77994_a >= 4) continue;
                ++this.ovenItems[i].field_77994_a;
                --itemStack.field_77994_a;
                return true;
            }
            this.ovenItems[i] = itemStack.func_77946_l();
            this.ovenItems[i].field_77994_a = 1;
            --itemStack.field_77994_a;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (this.isOpen()) {
            if ((double)(this.lidAngle + 0.1f) < 1.0) {
                this.lidAngle += 0.1f;
            }
        } else if ((double)(this.lidAngle - 0.1f) > 0.0) {
            this.lidAngle -= 0.1f;
        }
        if (!this.isOpen() && this.hasCoal) {
            if (!this.isCooking) {
                if (this.canCookItems()) {
                    ++this.burnTime;
                    this.isCooking = true;
                } else {
                    this.burnTime = 0;
                }
            } else {
                ++this.burnTime;
            }
        } else {
            this.burnTime = 0;
        }
        if (this.burnTime == 0) {
            this.itemState = 0;
        }
        if (this.burnTime == 400) {
            this.itemState = 1;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.cookItems();
        }
        if (this.burnTime == 600) {
            this.itemState = 2;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.burnItems();
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean hasCoal() {
        return this.hasCoal;
    }

    public int getItemState() {
        return this.itemState;
    }

    public ItemStack[] getOvenItems() {
        return this.ovenItems;
    }

    public float getLidAngle() {
        return this.lidAngle;
    }

    public boolean canCookItems() {
        boolean foundCompatible = false;
        for (ItemStack item : this.ovenItems) {
            if (item == null) continue;
            if (FurnaceRecipes.func_77602_a().func_151395_a(item) != null && FurnaceRecipes.func_77602_a().func_151395_a(item).func_77973_b() instanceof ItemFood) {
                foundCompatible = true;
            }
            if (OvenRecipes.getCookingResult(item) == null) continue;
            foundCompatible = true;
        }
        return foundCompatible;
    }

    public void setOpen() {
        this.isOpen = true;
        this.hasCoal = false;
        this.isCooking = false;
    }

    public void setClosed() {
        this.isOpen = false;
        this.burnTime = 0;
    }

    public void cookItems() {
        for (int i = 0; i < this.ovenItems.length; ++i) {
            int stackSize;
            if (this.ovenItems[i] == null || this.ovenItems[i].func_77973_b() == null) continue;
            if (FurnaceRecipes.func_77602_a().func_151395_a(this.ovenItems[i]) != null) {
                stackSize = this.ovenItems[i].field_77994_a;
                this.ovenItems[i] = FurnaceRecipes.func_77602_a().func_151395_a(this.ovenItems[i]);
                this.ovenItems[i].field_77994_a = stackSize;
            }
            if (OvenRecipes.getCookingResult(this.ovenItems[i]) == null) continue;
            stackSize = this.ovenItems[i].field_77994_a;
            this.ovenItems[i] = OvenRecipes.getCookingResult(this.ovenItems[i]);
            this.ovenItems[i].field_77994_a = stackSize;
        }
    }

    public ItemStack removeTopItem() {
        ItemStack itemStack = null;
        for (int i = 3; i >= 0; --i) {
            if (this.ovenItems[i] == null || this.ovenItems[i].func_77973_b() == null) continue;
            itemStack = this.ovenItems[i].func_77946_l();
            this.ovenItems[i] = null;
            break;
        }
        if (itemStack != null) {
            return itemStack;
        }
        return null;
    }

    public void burnItems() {
        for (int i = 0; i < this.ovenItems.length; ++i) {
            if (this.ovenItems[i] == null || this.ovenItems[i].func_77973_b() == null) continue;
            int stackSize = this.ovenItems[i].field_77994_a;
            this.ovenItems[i] = new ItemStack(KitchenItems.burnt_meat, stackSize);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74777_a("CookTime", (short)this.burnTime);
        compound.func_74757_a("IsOpen", this.isOpen());
        compound.func_74757_a("HasCoal", this.hasCoal);
        compound.func_74777_a("ItemState", (short)this.itemState);
        compound.func_74757_a("IsCooking", this.isCooking);
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.ovenItems.length; ++i) {
            if (this.ovenItems[i] == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            this.ovenItems[i].func_77955_b(itemCompound);
            nbtTagList.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbtTagList);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.burnTime = compound.func_74765_d("CookTime");
        this.isOpen = compound.func_74767_n("IsOpen");
        this.hasCoal = compound.func_74767_n("HasCoal");
        this.itemState = compound.func_74765_d("ItemState");
        this.isCooking = compound.func_74767_n("IsCooking");
        this.ovenItems = new ItemStack[4];
        NBTTagList nbtTagList = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = nbtTagList.func_150305_b(i);
            byte slot = itemCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.ovenItems.length) continue;
            this.ovenItems[slot] = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
        }
    }
}

