/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen;

import cpw.mods.fml.common.registry.GameRegistry;
import dk.mrspring.kitchen.ModConfig;
import dk.mrspring.kitchen.ModLogger;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class OvenRecipes {
    static ArrayList<ItemStack>[] customOvenRecipes = new ArrayList[2];

    public static void load() {
        if (ModConfig.customOvenRecipes.length == ModConfig.customOvenRecipeResults.length) {
            ArrayList<ItemStack> input = OvenRecipes.getArrayFromStringList(ModConfig.customOvenRecipes, "Custom Oven Recipes Input");
            ArrayList<ItemStack> output = OvenRecipes.getArrayFromStringList(ModConfig.customOvenRecipeResults, "Custom Oven Recipes Output");
            if (input.size() == output.size()) {
                OvenRecipes.customOvenRecipes[0] = input;
                OvenRecipes.customOvenRecipes[1] = output;
            } else {
                ModLogger.print(0, "Unable to load Custom oven recipes! Loading defaults.", new Object[0]);
                ModLogger.print(3, "Some of the Items it was trying to load has wrong names. Correct this issue to load custom recipes!", new Object[0]);
                OvenRecipes.customOvenRecipes[0] = OvenRecipes.getArrayFromStringList(ModConfig.defaultCustomOvenRecipes, "Default Oven Recipes Input");
                OvenRecipes.customOvenRecipes[1] = OvenRecipes.getArrayFromStringList(ModConfig.defaultCustomOvenRecipeResults, "Default Oven Recipes Output");
            }
        } else {
            ModLogger.print(0, "Unable to load Custom oven recipes! Loading defaults.", new Object[0]);
            ModLogger.print(3, "One of the list were bigger than the other! Input length: " + ModConfig.customOvenRecipes.length + ", Output length: " + ModConfig.customOvenRecipeResults.length, new Object[0]);
            OvenRecipes.customOvenRecipes[0] = OvenRecipes.getArrayFromStringList(ModConfig.defaultCustomOvenRecipes, "Default Oven Recipes Input");
            OvenRecipes.customOvenRecipes[1] = OvenRecipes.getArrayFromStringList(ModConfig.defaultCustomOvenRecipeResults, "Default Oven Recipes Output");
        }
    }

    public static ItemStack getCookingResult(ItemStack itemStack) {
        for (int i = 0; i < customOvenRecipes[0].size(); ++i) {
            ItemStack stack = customOvenRecipes[0].get(i);
            if (!itemStack.func_77969_a(stack)) continue;
            return customOvenRecipes[1].get(i);
        }
        return null;
    }

    public static ArrayList<ItemStack> getArrayFromStringList(String[] list, String type) {
        ArrayList<ItemStack> itemStackArrayList = new ArrayList<ItemStack>();
        for (String aList : list) {
            String itemName;
            String modId = "minecraft";
            if (aList.contains(":")) {
                modId = aList.split(":")[0];
                itemName = aList.split(":")[1];
            } else {
                itemName = aList;
            }
            ItemStack stack = GameRegistry.findItemStack((String)modId, (String)itemName, (int)1);
            if (stack != null) {
                ModLogger.print(3, "Adding " + stack.func_82833_r() + " to '" + type + "'.", new Object[0]);
                itemStackArrayList.add(stack);
                continue;
            }
            ModLogger.print(3, "Unable to add ItemStack to '" + type + "', it returned null. ModID: " + modId + ", name: " + itemName + ".", new Object[0]);
        }
        return itemStackArrayList;
    }
}

