/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.core;

import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiChatTC;
import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TCChatLine;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.TCSettingsAdvanced;
import acs.tabbychat.gui.TCSettingsFilters;
import acs.tabbychat.gui.TCSettingsGeneral;
import acs.tabbychat.gui.TCSettingsServer;
import acs.tabbychat.gui.TCSettingsSpelling;
import acs.tabbychat.jazzy.TCSpellCheckManager;
import acs.tabbychat.settings.ChannelDelimEnum;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.TCChatFilter;
import acs.tabbychat.threads.BackgroundUpdateCheck;
import acs.tabbychat.util.ChatComponentUtils;
import acs.tabbychat.util.ComponentList;
import acs.tabbychat.util.TabbyChatUtils;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.Logger;

public class TabbyChat {
    private static Logger log = TabbyChatUtils.log;
    private volatile List<TCChatLine> lastChat = Lists.newArrayList();
    private static boolean firstRun = true;
    public static boolean liteLoaded = false;
    public static boolean modLoaded = false;
    public static boolean forgePresent = false;
    private static boolean updateChecked = false;
    private static String mcversion = new ServerData((String)"", (String)"").field_82822_g;
    public static boolean defaultUnicode;
    public static String version;
    public static Minecraft mc;
    public static TCSettingsGeneral generalSettings;
    public static TCSettingsServer serverSettings;
    public static TCSettingsFilters filterSettings;
    public static TCSettingsSpelling spellingSettings;
    public static TCSettingsAdvanced advancedSettings;
    public static TCSpellCheckManager spellChecker;
    public LinkedHashMap<String, ChatChannel> channelMap = new LinkedHashMap();
    private static File chanDataFile;
    protected Calendar cal = Calendar.getInstance();
    protected Semaphore serverDataLock = new Semaphore(0, true);
    private Pattern chatChannelPatternClean = Pattern.compile("^\\[([\\p{L}0-9_]{1,10})\\]");
    private Pattern chatChannelPatternDirty = Pattern.compile("^\\[([\\p{L}0-9_]{1,10})\\]");
    private Pattern chatPMfromMePattern = null;
    private Pattern chatPMtoMePattern = null;
    private final ReentrantReadWriteLock lastChatLock = new ReentrantReadWriteLock(true);
    private final Lock lastChatReadLock = this.lastChatLock.readLock();
    private final Lock lastChatWriteLock = this.lastChatLock.writeLock();
    private static GuiNewChatTC gnc;
    private static TabbyChat instance;

    public static TabbyChat getInstance() {
        return instance;
    }

    public static TabbyChat getInstance(GuiNewChatTC gncInstance) {
        if (instance == null) {
            instance = new TabbyChat(gncInstance);
        }
        return instance;
    }

    public static String getNewestVersion() {
        String updateURL = liteLoaded ? "http://tabbychat.port0.org/tabbychat/current_version.php?type=LL&mc=" + mcversion : "http://tabbychat.port0.org/tabbychat/current_version.php?mc=" + mcversion;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(updateURL).openConnection();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String newestVersion = buffer.readLine();
            buffer.close();
            return newestVersion;
        }
        catch (Throwable e) {
            TabbyChat.printErr("Unable to check for TabbyChat update.");
            return version;
        }
    }

    public static void printErr(String err) {
        log.warn("[TABBYCHAT] " + err);
    }

    public static void printException(String err, Exception e) {
        log.warn("[TABBYCHAT] " + err, (Throwable)e);
    }

    public static void printMessageToChat(String msg) {
        if (instance == null) {
            return;
        }
        if (!TabbyChat.instance.channelMap.containsKey("TabbyChat")) {
            TabbyChat.instance.channelMap.put("TabbyChat", new ChatChannel("TabbyChat"));
        }
        boolean firstLine = true;
        List split = TabbyChat.mc.field_71466_p.func_78271_c(msg, ChatBox.getMinChatWidth());
        for (String splitMsg : split) {
            if (firstLine) {
                instance.addToChannel("TabbyChat", new TCChatLine(TabbyChat.mc.field_71456_v.func_73834_c(), (IChatComponent)new ChatComponentText(splitMsg), 0, true), false);
            } else {
                instance.addToChannel("TabbyChat", new TCChatLine(TabbyChat.mc.field_71456_v.func_73834_c(), (IChatComponent)new ChatComponentText(" " + splitMsg), 0, true), false);
            }
            firstLine = false;
        }
    }

    private TabbyChat(GuiNewChatTC gncInstance) {
        mc = Minecraft.func_71410_x();
        gnc = gncInstance;
        generalSettings = new TCSettingsGeneral(this);
        serverSettings = new TCSettingsServer(this);
        filterSettings = new TCSettingsFilters(this);
        spellingSettings = new TCSettingsSpelling(this);
        advancedSettings = new TCSettingsAdvanced(this);
        spellChecker = TCSpellCheckManager.getInstance();
        generalSettings.loadSettingsFile();
        spellingSettings.loadSettingsFile();
        advancedSettings.loadSettingsFile();
        defaultUnicode = TabbyChat.mc.field_71466_p.func_82883_a();
    }

    public void activateIndex(int ind) {
        List<String> actives = this.getActive();
        if (actives.size() == 1) {
            int i = 1;
            for (ChatChannel chan : this.channelMap.values()) {
                if (i == ind) {
                    if (TabbyChat.mc.field_71462_r instanceof GuiChatTC) {
                        ((GuiChatTC)TabbyChat.mc.field_71462_r).checkCommandPrefixChange(this.channelMap.get(actives.get(0)), chan);
                    }
                    this.resetDisplayedChat();
                    return;
                }
                ++i;
            }
        }
    }

    public void activateNext() {
        List<String> actives = this.getActive();
        if (actives.size() == 1) {
            Iterator<ChatChannel> iter = this.channelMap.values().iterator();
            ChatChannel chan = iter.next();
            while (iter.hasNext()) {
                if (chan.getTitle().equals(actives.get(0))) {
                    if (TabbyChat.mc.field_71462_r instanceof GuiChatTC) {
                        ((GuiChatTC)TabbyChat.mc.field_71462_r).checkCommandPrefixChange(chan, iter.next());
                    }
                    this.resetDisplayedChat();
                    return;
                }
                chan = iter.next();
            }
            if (chan.getTitle().equals(actives.get(0))) {
                iter = this.channelMap.values().iterator();
                if (iter.hasNext() && TabbyChat.mc.field_71462_r instanceof GuiChatTC) {
                    ((GuiChatTC)TabbyChat.mc.field_71462_r).checkCommandPrefixChange(chan, iter.next());
                }
                this.resetDisplayedChat();
            }
        }
    }

    public void activatePrev() {
        List<String> actives = this.getActive();
        if (actives.size() == 1) {
            ListIterator<Object> iter = Lists.newArrayList(this.channelMap.values()).listIterator(this.channelMap.size());
            ChatChannel chan = (ChatChannel)iter.previous();
            while (iter.hasPrevious()) {
                if (chan.getTitle().equals(actives.get(0))) {
                    if (TabbyChat.mc.field_71462_r instanceof GuiChatTC) {
                        ((GuiChatTC)TabbyChat.mc.field_71462_r).checkCommandPrefixChange(chan, (ChatChannel)iter.previous());
                    }
                    this.resetDisplayedChat();
                    return;
                }
                chan = (ChatChannel)iter.previous();
            }
            if (chan.getTitle().equals(actives.get(0))) {
                chan.active = false;
                iter = new ArrayList<ChatChannel>(this.channelMap.values()).listIterator(this.channelMap.size());
                if (iter.hasPrevious() && TabbyChat.mc.field_71462_r instanceof GuiChatTC) {
                    ((GuiChatTC)TabbyChat.mc.field_71462_r).checkCommandPrefixChange(chan, (ChatChannel)iter.previous());
                }
                this.resetDisplayedChat();
            }
        }
    }

    private void addOptionalTimeStamp(List<TCChatLine> orig) {
        for (TCChatLine line : orig) {
            line.timeStamp = this.getTimeStamp();
        }
    }

    public void addToChannel(String _name, List<TCChatLine> thisChat, boolean visible) {
        block3: {
            block2: {
                ChatChannel theChan = this.channelMap.get(_name);
                if (theChan == null || !TabbyChat.generalSettings.groupSpam.getValue().booleanValue()) break block2;
                this.spamCheck(theChan, thisChat);
                if (theChan.hasSpam) break block3;
                for (TCChatLine cl : thisChat) {
                    this.addToChannel(_name, cl, visible);
                }
                break block3;
            }
            for (TCChatLine cl : thisChat) {
                this.addToChannel(_name, cl, visible);
            }
        }
    }

    public void addToChannel(String name, TCChatLine thisChat, boolean visible) {
        if (TabbyChat.serverSettings.ignoredChanPattern.matcher(name).matches()) {
            return;
        }
        ChatChannel theChan = this.channelMap.get(name);
        if (theChan == null) {
            if (this.channelMap.size() >= 20) {
                return;
            }
            theChan = new ChatChannel(name);
            this.channelMap.put(name, theChan);
            if (TabbyChat.mc.field_71462_r instanceof GuiChatTC) {
                ((GuiChatTC)TabbyChat.mc.field_71462_r).addChannelLive(theChan);
            }
        }
        theChan.addChat(thisChat, visible);
        theChan.trimLog();
    }

    public boolean channelExists(String name) {
        return this.channelMap.get(name) != null;
    }

    public void checkServer() {
        if (!updateChecked) {
            updateChecked = true;
            BackgroundUpdateCheck buc = new BackgroundUpdateCheck();
            buc.start();
        }
        if (!TabbyChat.serverSettings.serverIP.equals(TabbyChatUtils.getServerIp())) {
            this.storeChannelData();
            this.channelMap.clear();
            if (this.enabled()) {
                this.enable();
                this.resetDisplayedChat();
            } else {
                this.disable();
            }
        }
    }

    public void createNewChannel(String name) {
        if (this.channelExists(name)) {
            return;
        }
        if (name == null || name.length() <= 0 || this.channelMap.size() >= 20) {
            return;
        }
        this.channelMap.put(name, new ChatChannel(name));
    }

    public void disable() {
        this.channelMap.clear();
        this.channelMap.put("*", new ChatChannel("*"));
    }

    public void enable() {
        if (!this.channelMap.containsKey("*")) {
            this.channelMap.put("*", new ChatChannel("*"));
            this.channelMap.get((Object)"*").active = true;
        }
        if (firstRun) {
            firstRun = false;
            return;
        }
        this.serverDataLock.tryAcquire();
        this.updateChanDataPath(false);
        serverSettings.updateForServer();
        filterSettings.updateForServer();
        this.reloadServerData();
        this.reloadSettingsData(false);
        if (TabbyChat.serverSettings.serverIP.length() > 0) {
            this.loadPMPatterns();
        }
        this.serverDataLock.release();
        if (TabbyChat.generalSettings.saveChatLog.getValue().booleanValue() && TabbyChat.serverSettings.serverIP != null) {
            TabbyChatUtils.logChat("\nBEGIN CHAT LOGGING -- " + new SimpleDateFormat().format(Calendar.getInstance().getTime()), null);
        }
    }

    public boolean enabled() {
        return TabbyChat.generalSettings.tabbyChatEnable.getValue();
    }

    protected void finalize() {
        this.storeChannelData();
    }

    public List<String> getActive() {
        int n = this.channelMap.size();
        ArrayList<String> actives = new ArrayList<String>(n);
        for (ChatChannel chan : this.channelMap.values()) {
            if (!chan.active) continue;
            actives.add(chan.getTitle());
        }
        return actives;
    }

    private String getCleanTimeStamp() {
        return StringUtils.func_76338_a((String)this.getTimeStamp());
    }

    private String getTimeStamp() {
        return TabbyChat.generalSettings.timeStamp.format(Calendar.getInstance().getTime());
    }

    protected void loadChannelData() {
        LinkedHashMap importData = null;
        if (!chanDataFile.exists()) {
            return;
        }
        FileInputStream cFileStream = null;
        BufferedInputStream cBuffStream = null;
        ObjectInputStream cObjStream = null;
        try {
            cFileStream = new FileInputStream(chanDataFile);
            cBuffStream = new BufferedInputStream(cFileStream);
            cObjStream = new ObjectInputStream(cBuffStream);
            importData = (LinkedHashMap)cObjStream.readObject();
            cObjStream.close();
            cBuffStream.close();
        }
        catch (Exception e) {
            TabbyChat.printException("Unable to read channel data file : '" + e.getLocalizedMessage() + "'", e);
            return;
        }
        if (importData == null) {
            return;
        }
        int oldIDs = 0;
        try {
            for (Map.Entry chan : importData.entrySet()) {
                if (((String)chan.getKey()).contentEquals("TabbyChat")) continue;
                ChatChannel _new = null;
                if (!this.channelMap.containsKey(chan.getKey())) {
                    _new = new ChatChannel((String)chan.getKey());
                    _new.chanID = ((ChatChannel)chan.getValue()).chanID;
                    this.channelMap.put(_new.getTitle(), _new);
                } else {
                    _new = this.channelMap.get(chan.getKey());
                }
                _new.setAlias(((ChatChannel)chan.getValue()).getAlias());
                _new.active = ((ChatChannel)chan.getValue()).active;
                _new.notificationsOn = ((ChatChannel)chan.getValue()).notificationsOn;
                _new.hidePrefix = ((ChatChannel)chan.getValue()).hidePrefix;
                _new.cmdPrefix = ((ChatChannel)chan.getValue()).cmdPrefix;
                this.addToChannel((String)chan.getKey(), new TCChatLine(-1, (IChatComponent)new ChatComponentText("-- chat history from " + new SimpleDateFormat().format(chanDataFile.lastModified())), 0, true), true);
                _new.importOldChat((ChatChannel)chan.getValue());
                ++oldIDs;
            }
        }
        catch (ClassCastException e) {
            TabbyChat.printMessageToChat("Unable to load channel history data due to upgrade (sorry!)");
        }
        ChatChannel.nextID = 3600 + oldIDs;
        this.resetDisplayedChat();
    }

    protected void loadPatterns() {
        ChannelDelimEnum delims = (ChannelDelimEnum)TabbyChat.serverSettings.delimiterChars.getValue();
        String colCode = "";
        String fmtCode = "";
        if (TabbyChat.serverSettings.delimColorBool.getValue().booleanValue()) {
            colCode = ((ColorCodeEnum)TabbyChat.serverSettings.delimColorCode.getValue()).toCode();
        }
        if (TabbyChat.serverSettings.delimFormatBool.getValue().booleanValue()) {
            fmtCode = ((FormatCodeEnum)TabbyChat.serverSettings.delimFormatCode.getValue()).toCode();
        }
        String frmt = colCode + fmtCode;
        if (((ColorCodeEnum)TabbyChat.serverSettings.delimColorCode.getValue()).toString().equals("White")) {
            frmt = "(" + colCode + ")?" + fmtCode;
        } else if (frmt.length() > 7) {
            frmt = "[" + frmt + "]{2}";
        }
        if (frmt.length() > 0) {
            frmt = "(?i:" + frmt + ")";
        }
        if (frmt.length() == 0) {
            frmt = "(?i:\u00a7[0-9A-FK-OR])*";
        }
        this.chatChannelPatternDirty = Pattern.compile("^(\u00a7r)?" + frmt + "\\" + delims.open() + "([\\p{L}0-9_\u00a7]+)\\" + delims.close());
        this.chatChannelPatternClean = Pattern.compile("^\\" + delims.open() + "([\\p{L}0-9_]{1," + TabbyChat.advancedSettings.maxLengthChannelName.getValue() + "})\\" + delims.close());
    }

    protected void loadPMPatterns() {
        StringBuilder toMePM = new StringBuilder();
        StringBuilder fromMePM = new StringBuilder();
        toMePM.append("^\\[([\\p{L}\\p{N}_]{3,16})[ ]?\\-\\>[ ]?me\\]");
        fromMePM.append("^\\[me[ ]?\\-\\>[ ]?([\\p{L}\\p{N}_]{3,16})\\]");
        toMePM.append("|^\\(From ([\\p{L}\\p{N}_]{3,16})\\)[ ]?:");
        fromMePM.append("|^\\(To ([\\p{L}\\p{N}_]{3,16})\\)[ ]?:");
        toMePM.append("|^From ([\\p{L}\\p{N}_]{3,16})[ ]?:");
        fromMePM.append("|^To ([\\p{L}\\p{N}_]{3,16})[ ]?:");
        toMePM.append("|^([\\p{L}\\p{N}_]{3,16}) whispers to you:");
        fromMePM.append("|^You whisper to ([\\p{L}\\p{N}_]{3,16}):");
        if (TabbyChat.mc.field_71439_g != null && TabbyChat.mc.field_71439_g.func_70005_c_() != null) {
            String me = TabbyChat.mc.field_71439_g.func_70005_c_();
            toMePM.append("|^\\[([\\p{L}\\p{N}_]{3,16})[ ]?\\-\\>[ ]?").append(me).append("\\]");
            fromMePM.append("|^\\[").append(me).append("[ ]?\\-\\>[ ]?([\\p{L}\\p{N}_]{3,16})\\]");
        }
        try {
            String toMe = TabbyChat.serverSettings.pmTabRegexToMe.getValue().replace("{$player}", "([\\p{L}\\p{N}_]{3,16})");
            if (!toMe.isEmpty()) {
                Pattern.compile(toMe);
                toMePM.append("|").append(toMe);
            }
        }
        catch (PatternSyntaxException e) {
            log.error("Error while setting 'To me' regex.", (Throwable)e);
            TabbyChat.serverSettings.pmTabRegexToMe.setValue("");
            TabbyChat.printMessageToChat(ColorCodeEnum.RED.toCode() + "Unable to set 'To me' pm regex. See console for details.");
        }
        try {
            String fromMe = TabbyChat.serverSettings.pmTabRegexFromMe.getValue().replace("{$player}", "([\\p{L}\\p{N}_]{3,16})");
            if (!fromMe.isEmpty()) {
                Pattern.compile(fromMe);
                fromMePM.append("|").append(fromMe);
            }
        }
        catch (PatternSyntaxException e) {
            log.error("Error while setting 'From me' regex.", (Throwable)e);
            TabbyChat.serverSettings.pmTabRegexFromMe.setValue("");
            TabbyChat.printMessageToChat(ColorCodeEnum.RED.toCode() + "Unable to set 'From me' pm regex. See console for details.");
        }
        this.chatPMtoMePattern = Pattern.compile(toMePM.toString());
        this.chatPMfromMePattern = Pattern.compile(fromMePM.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollForUnread(Gui _gui, int _tick) {
        if (this.getActive().contains("*")) {
            return;
        }
        int _opacity = 0;
        int tickdiff = 50;
        this.lastChatReadLock.lock();
        try {
            if (this.lastChat != null && this.lastChat.size() > 0) {
                tickdiff = _tick - this.lastChat.get(0).func_74540_b();
            }
        }
        finally {
            this.lastChatReadLock.unlock();
        }
        if (tickdiff < 50) {
            float var6 = TabbyChat.mc.field_71474_y.field_74357_r * 0.9f + 0.1f;
            double var10 = (double)tickdiff / 50.0;
            var10 = 1.0 - var10;
            if ((var10 *= 10.0) < 0.0) {
                var10 = 0.0;
            }
            if (var10 > 1.0) {
                var10 = 1.0;
            }
            var10 *= var10;
            _opacity = (int)(255.0 * var10);
            if ((_opacity = (int)((float)_opacity * var6)) <= 3) {
                return;
            }
            ChatBox.updateTabs(this.channelMap);
            for (ChatChannel chan : this.channelMap.values()) {
                if (!chan.unread || !chan.notificationsOn) continue;
                chan.unreadNotify(_gui, _opacity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChat(List<TCChatLine> theChat) {
        if (this.serverDataLock.availablePermits() == 0) {
            this.serverDataLock.acquireUninterruptibly();
            this.serverDataLock.release();
        }
        if (theChat.isEmpty()) {
            return;
        }
        ArrayList<String> toTabs = new ArrayList<String>(20);
        ArrayList<String> filterTabs = new ArrayList<String>(20);
        String channelTab = null;
        String pmTab = null;
        toTabs.add("*");
        ComponentList raw = TabbyChatUtils.chatLinesToComponent(theChat);
        ComponentList filtered = this.processChatForFilters(raw, filterTabs);
        if (TabbyChat.generalSettings.saveChatLog.getValue().booleanValue()) {
            TabbyChatUtils.logChat(this.getCleanTimeStamp() + raw.getUnformattedText(), null);
        }
        if (filtered != null) {
            ChatChannel tab = null;
            if (TabbyChat.serverSettings.autoChannelSearch.getValue().booleanValue()) {
                channelTab = this.processChatForChannels(raw);
            }
            if (channelTab == null) {
                if (TabbyChat.serverSettings.autoPMSearch.getValue().booleanValue() && (pmTab = this.processChatForPMs(raw.getUnformattedText())) != null) {
                    tab = new ChatChannel(pmTab);
                    if (TabbyChat.generalSettings.saveChatLog.getValue().booleanValue() && TabbyChat.generalSettings.splitChatLog.getValue().booleanValue()) {
                        TabbyChatUtils.logChat(this.getCleanTimeStamp() + raw.getUnformattedText(), tab);
                    }
                }
            } else {
                toTabs.add(channelTab);
                tab = new ChatChannel(channelTab);
                if (TabbyChat.generalSettings.saveChatLog.getValue().booleanValue() && TabbyChat.generalSettings.splitChatLog.getValue().booleanValue()) {
                    TabbyChatUtils.logChat(this.getCleanTimeStamp() + raw.getUnformattedText(), tab);
                }
            }
            toTabs.addAll(filterTabs);
        } else {
            filtered = raw;
        }
        List<TCChatLine> resultChatLine = TabbyChatUtils.componentToChatLines(theChat.get(0).func_74540_b(), filtered, theChat.get(0).func_74539_c(), theChat.get((int)0).statusMsg);
        this.addOptionalTimeStamp(resultChatLine);
        HashSet tabSet = new HashSet(toTabs);
        List<String> activeTabs = this.getActive();
        boolean visible = false;
        if (pmTab != null) {
            if (!this.channelMap.containsKey(pmTab)) {
                ChatChannel pm = new ChatChannel(pmTab);
                pm.cmdPrefix = "/msg " + pmTab;
                this.channelMap.put(pmTab, pm);
                this.addToChannel(pmTab, resultChatLine, false);
                if (TabbyChat.mc.field_71462_r instanceof GuiChatTC) {
                    ((GuiChatTC)TabbyChat.mc.field_71462_r).addChannelLive(pm);
                }
            } else if (this.channelMap.containsKey(pmTab)) {
                if (activeTabs.contains(pmTab)) {
                    visible = true;
                }
                this.addToChannel(pmTab, resultChatLine, visible);
            }
        }
        if (!visible) {
            Set tabUnion = (Set)tabSet.clone();
            tabUnion.retainAll(activeTabs);
            if (tabUnion.size() > 0) {
                visible = true;
            }
        }
        for (String tab : tabSet) {
            this.addToChannel(tab, resultChatLine, visible);
        }
        this.lastChatWriteLock.lock();
        try {
            this.lastChat = TabbyChat.generalSettings.groupSpam.getValue().booleanValue() && activeTabs.size() > 0 ? (toTabs.contains(activeTabs.get(0)) ? this.channelMap.get(activeTabs.get(0)).getChatLogSublistCopy(0, resultChatLine.size()) : resultChatLine) : resultChatLine;
        }
        finally {
            this.lastChatWriteLock.unlock();
        }
        this.lastChatReadLock.lock();
        try {
            if (visible) {
                if (TabbyChat.generalSettings.groupSpam.getValue().booleanValue() && this.channelMap.get((Object)activeTabs.get((int)0)).hasSpam) {
                    gnc.setChatLines(0, new ArrayList<TCChatLine>(this.lastChat));
                } else {
                    gnc.addChatLines(0, new ArrayList<TCChatLine>(this.lastChat));
                }
            }
        }
        finally {
            this.lastChatReadLock.unlock();
        }
    }

    private String processChatForChannels(ComponentList raw) {
        boolean dirtyCheck;
        Matcher findChannelClean = this.chatChannelPatternClean.matcher(raw.getUnformattedText());
        Matcher findChannelDirty = this.chatChannelPatternDirty.matcher(raw.getFormattedText());
        boolean bl = dirtyCheck = TabbyChat.serverSettings.delimColorBool.getValue() == false && TabbyChat.serverSettings.delimFormatBool.getValue() == false ? true : findChannelDirty.find();
        if (findChannelClean.find() && dirtyCheck) {
            return findChannelClean.group(1);
        }
        return null;
    }

    private ComponentList processChatForFilters(ComponentList raw, List<String> destinations) {
        if (raw == null) {
            return null;
        }
        for (int i = 0; i < raw.size(); ++i) {
            IChatComponent chat = (IChatComponent)raw.get(i);
            Map.Entry<Integer, TCChatFilter> iFilter = TabbyChat.filterSettings.filterMap.firstEntry();
            while (iFilter != null) {
                if (iFilter.getValue().applyFilterToDirtyChat(chat)) {
                    if (iFilter.getValue().removeMatches) {
                        return ComponentList.newInstance();
                    }
                    if (iFilter.getValue().highlightBool) {
                        int[] lastMatch = iFilter.getValue().getLastMatch();
                        for (int i1 = 0; i1 < lastMatch.length; i1 += 2) {
                            int start = lastMatch[i1];
                            int end = lastMatch[i1 + 1];
                            IChatComponent chat1 = ChatComponentUtils.subComponent(chat, 0, start);
                            IChatComponent chat2 = ChatComponentUtils.subComponent(chat, start, end);
                            IChatComponent chat3 = ChatComponentUtils.subComponent(chat, end);
                            ChatStyle style = chat2.func_150256_b();
                            if (iFilter.getValue().highlightColor != ColorCodeEnum.DEFAULT) {
                                style.func_150238_a(iFilter.getValue().highlightColor.toVanilla());
                            }
                            switch (iFilter.getValue().highlightFormat) {
                                case BOLD: {
                                    style.func_150227_a(Boolean.valueOf(true));
                                    break;
                                }
                                case ITALIC: {
                                    style.func_150217_b(Boolean.valueOf(true));
                                    break;
                                }
                                case STRIKED: {
                                    style.func_150225_c(Boolean.valueOf(true));
                                    break;
                                }
                                case UNDERLINE: {
                                    style.func_150228_d(Boolean.valueOf(true));
                                    break;
                                }
                                case MAGIC: {
                                    style.func_150237_e(Boolean.valueOf(true));
                                    break;
                                }
                            }
                            chat = chat1.func_150257_a(chat2).func_150257_a(chat3);
                        }
                        raw.set(i, chat);
                    }
                    if (iFilter.getValue().sendToTabBool) {
                        if (iFilter.getValue().sendToAllTabs) {
                            for (ChatChannel chan : this.channelMap.values()) {
                                destinations.add(chan.getTitle());
                            }
                        } else {
                            String destTab = iFilter.getValue().getTabName();
                            if (destTab != null && destTab.length() > 0 && !destinations.contains(destTab)) {
                                destinations.add(destTab);
                            }
                        }
                    }
                    if (iFilter.getValue().audioNotificationBool) {
                        iFilter.getValue().audioNotification();
                    }
                }
                iFilter = TabbyChat.filterSettings.filterMap.higherEntry(iFilter.getKey());
            }
        }
        return raw;
    }

    private String processChatForPMs(String raw) {
        block2: {
            Matcher findPMfromMe;
            block3: {
                if (this.chatPMtoMePattern == null) break block2;
                Matcher findPMtoMe = this.chatPMtoMePattern.matcher(raw);
                if (!findPMtoMe.find()) break block3;
                for (int i = 1; i <= findPMtoMe.groupCount(); ++i) {
                    if (findPMtoMe.group(i) == null) continue;
                    return findPMtoMe.group(i);
                }
                break block2;
            }
            if (this.chatPMfromMePattern == null || !(findPMfromMe = this.chatPMfromMePattern.matcher(raw)).find()) break block2;
            for (int i = 1; i <= findPMfromMe.groupCount(); ++i) {
                if (findPMfromMe.group(i) == null) continue;
                return findPMfromMe.group(i);
            }
        }
        return null;
    }

    private void reloadServerData() {
        serverSettings.loadSettingsFile();
        filterSettings.loadSettingsFile();
        this.loadChannelData();
    }

    public void reloadSettingsData(boolean withSave) {
        this.updateDefaults();
        this.loadPatterns();
        this.loadPMPatterns();
        this.updateFilters();
        if (withSave) {
            this.storeChannelData();
        }
    }

    public void removeTab(String _name) {
        this.channelMap.remove(_name);
    }

    public void resetDisplayedChat() {
        gnc.clearChatLines();
        List<String> actives = this.getActive();
        if (actives.size() < 1) {
            return;
        }
        gnc.addChatLines(this.channelMap.get(actives.get(0)));
        int n = actives.size();
        for (int i = 1; i < n; ++i) {
            gnc.mergeChatLines(this.channelMap.get(actives.get(i)));
        }
    }

    private void spamCheck(ChatChannel theChan, List<TCChatLine> lastChat) {
        int i;
        String oldChat = "";
        String newChat = "";
        if (theChan.getChatLogSize() < lastChat.size() || lastChat.size() == 0) {
            theChan.hasSpam = false;
            theChan.spamCount = 1;
            return;
        }
        int _size = lastChat.size();
        for (i = 0; i < _size; ++i) {
            if (lastChat.get(i).getChatLineString() == null || theChan.getChatLine(i).getChatLineString() == null) continue;
            newChat = newChat + lastChat.get(i).getChatLineString().func_150260_c();
            oldChat = theChan.getChatLine(i).getChatLineString().func_150260_c() + oldChat;
        }
        if (theChan.hasSpam) {
            oldChat = oldChat.substring(0, oldChat.length() - 4 - Integer.toString(theChan.spamCount).length());
        }
        if (oldChat.equals(newChat)) {
            theChan.hasSpam = true;
            ++theChan.spamCount;
            for (i = 1; i < _size; ++i) {
                TCChatLine line = new TCChatLine(lastChat.get(0).func_74540_b(), lastChat.get(lastChat.size() - i - 1).getChatLineString(), lastChat.get(0).func_74539_c());
                line.timeStamp = this.getTimeStamp();
                theChan.setChatLogLine(i, line);
            }
            TCChatLine line = new TCChatLine(lastChat.get(0).func_74540_b(), lastChat.get(lastChat.size() - 1).getChatLineString().func_150259_f().func_150258_a(" [" + theChan.spamCount + "x]"), lastChat.get(0).func_74539_c());
            line.timeStamp = this.getTimeStamp();
            theChan.setChatLogLine(0, line);
        } else {
            theChan.hasSpam = false;
            theChan.spamCount = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeChannelData() {
        if (chanDataFile == null) {
            return;
        }
        if (!chanDataFile.getParentFile().exists()) {
            chanDataFile.getParentFile().mkdirs();
        }
        FileOutputStream cFileStream = null;
        BufferedOutputStream cBuffStream = null;
        ObjectOutputStream cObjStream = null;
        try {
            cFileStream = new FileOutputStream(chanDataFile);
            cBuffStream = new BufferedOutputStream(cFileStream);
            cObjStream = new ObjectOutputStream(cBuffStream);
            cObjStream.writeObject(TabbyChat.instance.channelMap);
            cObjStream.flush();
        }
        catch (Exception e) {
            try {
                TabbyChat.printErr("Unable to write channel data to file : '" + e.getLocalizedMessage() + "' : " + e.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(cFileStream);
                IOUtils.closeQuietly(cObjStream);
                IOUtils.closeQuietly(cBuffStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)cFileStream);
            IOUtils.closeQuietly((Closeable)cObjStream);
            IOUtils.closeQuietly((Closeable)cBuffStream);
        }
        IOUtils.closeQuietly((Closeable)cFileStream);
        IOUtils.closeQuietly((Closeable)cObjStream);
        IOUtils.closeQuietly((Closeable)cBuffStream);
    }

    private void updateChanDataPath(boolean make) {
        String pName = "";
        if (TabbyChat.mc.field_71439_g != null && TabbyChat.mc.field_71439_g.func_70005_c_() != null) {
            pName = TabbyChat.mc.field_71439_g.func_70005_c_();
        }
        File parentDir = TabbyChatUtils.getServerDir();
        if (make && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        chanDataFile = new File(parentDir, pName + "_chanData.ser");
    }

    protected void updateDefaults() {
        if (!TabbyChat.generalSettings.tabbyChatEnable.getValue().booleanValue()) {
            return;
        }
        ArrayList<String> dList = new ArrayList<String>(TabbyChat.serverSettings.defaultChanList);
        for (ChatChannel chan : this.channelMap.values()) {
            int ind = dList.indexOf(chan.getTitle());
            if (ind < 0) continue;
            dList.remove(ind);
        }
        for (String defChan : dList) {
            if (defChan.length() <= 0) continue;
            this.channelMap.put(defChan, new ChatChannel(defChan));
        }
    }

    protected void updateFilters() {
        if (!TabbyChat.generalSettings.tabbyChatEnable.getValue().booleanValue()) {
            return;
        }
        if (TabbyChat.filterSettings.filterMap.size() == 0) {
            return;
        }
        Map.Entry<Integer, TCChatFilter> iFilter = TabbyChat.filterSettings.filterMap.firstEntry();
        while (iFilter != null) {
            String newName = iFilter.getValue().sendToTabName;
            if (iFilter.getValue().sendToTabBool && !iFilter.getValue().sendToAllTabs && !this.channelMap.containsKey(newName) && !newName.startsWith("%")) {
                this.channelMap.put(newName, new ChatChannel(newName));
            }
            iFilter = TabbyChat.filterSettings.filterMap.higherEntry(iFilter.getKey());
        }
    }

    static {
        version = "1.11.1.59";
        instance = null;
    }
}

