/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.PrefsButton;
import acs.tabbychat.settings.ITCSetting;
import acs.tabbychat.settings.TCSettingBool;
import acs.tabbychat.settings.TCSettingTextBox;
import acs.tabbychat.util.TabbyChatUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public class ChatChannelGUI
extends GuiScreen {
    protected ChatChannel channel;
    public final int displayWidth = 255;
    public final int displayHeight = 120;
    private String title;
    private int position;
    private TabbyChat tc;
    private static final int SAVE_ID = 8981;
    private static final int CANCEL_ID = 8982;
    private static final int NOTIFICATIONS_ON_ID = 8983;
    private static final int ALIAS_ID = 8984;
    private static final int CMD_PREFIX_ID = 8985;
    private static final int PREV_ID = 8986;
    private static final int NEXT_ID = 8987;
    private static final int HIDE_PREFIX = 8988;
    private TCSettingBool hidePrefix = new TCSettingBool(false, "hidePrefix", "settings.channel", 8988);
    private TCSettingBool notificationsOn = new TCSettingBool(false, "notificationsOn", "settings.channel", 8983);
    private TCSettingTextBox alias = new TCSettingTextBox("", "alias", "settings.channel", 8984);
    private TCSettingTextBox cmdPrefix = new TCSettingTextBox("", "cmdPrefix", "settings.channel", 8985);

    public ChatChannelGUI(ChatChannel _c) {
        GuiNewChatTC.getInstance();
        this.tc = GuiNewChatTC.tc;
        this.channel = _c;
        this.hidePrefix.setValue(_c.hidePrefix);
        this.notificationsOn.setValue(_c.notificationsOn);
        this.alias.setCharLimit(20);
        this.alias.setValue(_c.getAlias());
        this.cmdPrefix.setCharLimit(100);
        this.cmdPrefix.setValue(_c.cmdPrefix);
        this.resetTempVars();
        this.title = _c.getTitle();
    }

    public void func_146284_a(GuiButton _button) {
        switch (_button.field_146127_k) {
            case 8981: {
                this.channel.notificationsOn = this.notificationsOn.getTempValue();
                this.channel.setAlias(this.alias.getTempValue().trim());
                this.channel.cmdPrefix = this.cmdPrefix.getTempValue().trim();
                this.channel.hidePrefix = this.hidePrefix.getTempValue();
                this.tc.storeChannelData();
            }
            case 8982: {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                break;
            }
            case 8983: {
                this.notificationsOn.actionPerformed();
                break;
            }
            case 8986: {
                if (this.position <= 2) {
                    return;
                }
                LinkedHashMap<String, ChatChannel> newMap = TabbyChatUtils.swapChannels(this.tc.channelMap, this.position - 2, this.position - 1);
                this.tc.channelMap.clear();
                this.tc.channelMap = newMap;
                --this.position;
                break;
            }
            case 8987: {
                if (this.position >= this.tc.channelMap.size()) {
                    return;
                }
                LinkedHashMap<String, ChatChannel> newMap2 = TabbyChatUtils.swapChannels(this.tc.channelMap, this.position - 1, this.position);
                this.tc.channelMap.clear();
                this.tc.channelMap = newMap2;
                ++this.position;
                break;
            }
            case 8988: {
                this.hidePrefix.actionPerformed();
            }
        }
    }

    public void func_73863_a(int _x, int _y, float _f) {
        int leftX = (this.field_146294_l - this.displayWidth) / 2;
        int topY = (this.field_146295_m - this.displayHeight) / 2;
        int rightX = leftX + this.displayWidth;
        ChatChannelGUI.func_73734_a((int)leftX, (int)topY, (int)(leftX + this.displayWidth), (int)(topY + this.displayHeight), (int)-2013265920);
        ChatChannelGUI.func_73734_a((int)leftX, (int)(topY + 14), (int)(leftX + this.displayWidth), (int)(topY + 15), (int)-1996488705);
        this.func_73731_b(this.field_146297_k.field_71466_p, this.title, leftX + 3, topY + 3, 0xAAAAAA);
        this.func_73731_b(this.field_146297_k.field_71466_p, Integer.toString(this.position), rightX - 34, topY + 22, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"settings.channel.position", (Object[])new Object[0]), rightX - 55 - this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"settings.channel.position", (Object[])new Object[0])), topY + 22, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"settings.channel.of", (Object[])new Object[0]) + " " + this.tc.channelMap.size(), rightX - 34, topY + 35, 0xFFFFFF);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_146112_a(this.field_146297_k, _x, _y);
        }
    }

    public void func_73866_w_() {
        int leftX = (this.field_146294_l - this.displayWidth) / 2;
        int topY = (this.field_146295_m - this.displayHeight) / 2;
        int rightX = leftX + this.displayWidth;
        int botY = topY + this.displayHeight;
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        PrefsButton savePrefs = new PrefsButton(8981, rightX - 45, botY - 19, 40, 14, I18n.func_135052_a((String)"settings.save", (Object[])new Object[0]));
        this.field_146292_n.add(savePrefs);
        PrefsButton cancelPrefs = new PrefsButton(8982, rightX - 90, botY - 19, 40, 14, I18n.func_135052_a((String)"settings.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(cancelPrefs);
        PrefsButton nextButton = new PrefsButton(8987, rightX - 20, topY + 20, 15, 14, ">>");
        this.field_146292_n.add(nextButton);
        PrefsButton prevButton = new PrefsButton(8986, rightX - 50, topY + 20, 15, 14, "<<");
        this.field_146292_n.add(prevButton);
        this.alias.setLabelLoc(leftX + 15);
        this.alias.setButtonLoc(leftX + 20 + this.field_146297_k.field_71466_p.func_78256_a(this.alias.description), topY + 20);
        this.alias.setButtonDims(70, 11);
        this.field_146292_n.add(this.alias);
        this.notificationsOn.setButtonLoc(leftX + 15, topY + 40);
        this.notificationsOn.setLabelLoc(leftX + 34);
        this.field_146292_n.add(this.notificationsOn);
        this.cmdPrefix.setLabelLoc(leftX + 15);
        this.cmdPrefix.setButtonLoc(leftX + 20 + this.field_146297_k.field_71466_p.func_78256_a(this.cmdPrefix.description), topY + 57);
        this.cmdPrefix.setButtonDims(100, 11);
        this.field_146292_n.add(this.cmdPrefix);
        this.hidePrefix.setButtonLoc(leftX + 15, topY + 78);
        this.hidePrefix.setLabelLoc(leftX + 34);
        this.field_146292_n.add(this.hidePrefix);
        this.position = 1;
        Iterator<String> _chanPtr = this.tc.channelMap.keySet().iterator();
        while (_chanPtr.hasNext() && !this.channel.getTitle().equals(_chanPtr.next())) {
            ++this.position;
        }
        for (Object drawable : this.field_146292_n) {
            if (!(drawable instanceof ITCSetting)) continue;
            ((ITCSetting)drawable).resetDescription();
        }
    }

    protected void func_73869_a(char par1, int par2) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ITCSetting tmp;
            if (!ITCSetting.class.isInstance(this.field_146292_n.get(i)) || (tmp = (ITCSetting)this.field_146292_n.get(i)).getType() != "textbox") continue;
            ((TCSettingTextBox)tmp).keyTyped(par1, par2);
        }
        super.func_73869_a(par1, par2);
    }

    public void func_73864_a(int par1, int par2, int par3) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ITCSetting tmp;
            if (!ITCSetting.class.isInstance(this.field_146292_n.get(i)) || (tmp = (ITCSetting)this.field_146292_n.get(i)).getType() != "textbox") continue;
            tmp.mouseClicked(par1, par2, par3);
        }
        super.func_73864_a(par1, par2, par3);
    }

    public void resetTempVars() {
        this.hidePrefix.reset();
        this.notificationsOn.reset();
        this.alias.reset();
        this.cmdPrefix.reset();
    }
}

