/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.util;

import acs.tabbychat.util.ComponentList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;

public class ChatComponentUtils {
    private static final String WITH_DELIMITER = "((?<=%1$s)|(?=%1$s))";
    private static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;

    public static IChatComponent replaceText(IChatComponent chat, String regex, String replacement) {
        List iter = chat.func_150253_a();
        ChatComponentText newChat = new ChatComponentText("");
        for (IChatComponent next : iter) {
            ChatComponentText comp = new ChatComponentText(next.func_150260_c().replaceAll(regex, replacement));
            comp.func_150255_a(next.func_150256_b().func_150232_l());
            newChat.func_150257_a((IChatComponent)comp);
        }
        return newChat;
    }

    public static ComponentList split(IChatComponent chat, int limit) {
        ComponentList ichatList = ComponentList.newInstance();
        ComponentList list = ComponentList.newInstance();
        ComponentList list1 = ComponentList.newInstance();
        if (chat.func_150253_a().size() == 0) {
            list.add(chat);
        } else {
            list.addAll(chat.func_150253_a());
        }
        for (IChatComponent ichat : list) {
            if (ichat.func_150261_e().contains("\u00a7")) {
                list1.addAll(ChatComponentUtils.formattedStringToChat(ichat.func_150261_e()).func_150253_a());
                continue;
            }
            list1.add(ichat);
        }
        for (IChatComponent ichat : list1) {
            String[] str = ichat.func_150254_d().split(String.format(WITH_DELIMITER, " "));
            ArrayList<String> chatList = new ArrayList<String>();
            for (String s : str) {
                for (String s1 : fontRenderer.func_78271_c(s, limit)) {
                    chatList.add(StringUtils.func_76338_a((String)s1));
                }
            }
            for (String s : chatList) {
                IChatComponent a = new ChatComponentText(s).func_150255_a(ichat.func_150256_b().func_150232_l());
                ichatList.add(a);
            }
        }
        ComponentList chatList = ComponentList.newInstance();
        ChatComponentText newChat = new ChatComponentText("");
        for (IChatComponent ichat : ichatList) {
            if (fontRenderer.func_78256_a(newChat.func_150260_c() + ichat.func_150260_c()) <= limit) {
                newChat.func_150257_a(ichat);
                continue;
            }
            chatList.add(newChat.func_150257_a((IChatComponent)new ChatComponentText("")));
            newChat = new ChatComponentText("").func_150257_a(ichat);
        }
        if (!chatList.contains(newChat)) {
            chatList.add(newChat);
        }
        return chatList;
    }

    public static IChatComponent formattedStringToChat(String chat) {
        ChatComponentText newChat = new ChatComponentText("");
        String[] parts = chat.split("\u00a7");
        boolean first = true;
        for (String part : parts) {
            if (first) {
                first = false;
                newChat.func_150258_a(part);
                continue;
            }
            IChatComponent last = (IChatComponent)newChat.func_150253_a().get(newChat.func_150253_a().size() - 1);
            EnumChatFormatting format = null;
            for (EnumChatFormatting formats : EnumChatFormatting.values()) {
                if (!String.valueOf(formats.func_96298_a()).equals(part.substring(0, 1))) continue;
                format = formats;
            }
            if (format != null) {
                ChatComponentText chat1 = new ChatComponentText(part.substring(1));
                if (format.equals((Object)EnumChatFormatting.RESET)) {
                    chat1.func_150256_b().func_150238_a(EnumChatFormatting.WHITE);
                    chat1.func_150256_b().func_150227_a(Boolean.valueOf(false));
                    chat1.func_150256_b().func_150217_b(Boolean.valueOf(false));
                    chat1.func_150256_b().func_150237_e(Boolean.valueOf(false));
                    chat1.func_150256_b().func_150225_c(Boolean.valueOf(false));
                    chat1.func_150256_b().func_150228_d(Boolean.valueOf(false));
                } else {
                    chat1.func_150255_a(last.func_150256_b().func_150206_m());
                }
                if (format.func_96302_c()) {
                    chat1.func_150256_b().func_150238_a(format);
                }
                if (format.equals((Object)EnumChatFormatting.BOLD)) {
                    chat1.func_150256_b().func_150227_a(Boolean.valueOf(true));
                }
                if (format.equals((Object)EnumChatFormatting.ITALIC)) {
                    chat1.func_150256_b().func_150217_b(Boolean.valueOf(true));
                }
                if (format.equals((Object)EnumChatFormatting.UNDERLINE)) {
                    chat1.func_150256_b().func_150228_d(Boolean.valueOf(true));
                }
                if (format.equals((Object)EnumChatFormatting.OBFUSCATED)) {
                    chat1.func_150256_b().func_150237_e(Boolean.valueOf(true));
                }
                if (format.equals((Object)EnumChatFormatting.STRIKETHROUGH)) {
                    chat1.func_150256_b().func_150225_c(Boolean.valueOf(true));
                }
                newChat.func_150257_a((IChatComponent)chat1);
                continue;
            }
            last.func_150258_a("\u00a7" + part);
        }
        return newChat;
    }

    public static IChatComponent subComponent(IChatComponent chat, int index) {
        ChatComponentText result = new ChatComponentText("");
        int pos = 0;
        boolean found = false;
        for (IChatComponent ichat : chat.func_150253_a()) {
            String text = ichat.func_150260_c();
            if (text.length() + pos >= index) {
                if (found) {
                    result.func_150257_a(ichat);
                } else {
                    found = true;
                    ChatComponentText local = new ChatComponentText(text.substring(index - pos));
                    local.func_150255_a(ichat.func_150256_b().func_150206_m());
                    result.func_150257_a((IChatComponent)local);
                }
            }
            pos += text.length();
        }
        return result;
    }

    public static IChatComponent subComponent(IChatComponent chat, int start, int end) {
        ChatComponentText result = new ChatComponentText("");
        int pos = start;
        for (IChatComponent ichat : ChatComponentUtils.subComponent(chat, start).func_150253_a()) {
            String text = ichat.func_150260_c();
            if (pos + text.length() > end) {
                ChatComponentText local = new ChatComponentText(text.substring(0, end - pos));
                local.func_150256_b().func_150221_a(chat.func_150256_b().func_150232_l());
                result.func_150257_a((IChatComponent)local);
                break;
            }
            result.func_150257_a(ichat);
            pos += text.length();
        }
        return result;
    }
}

