/*
 * Decompiled with CFR 0.152.
 */
package DITextures;

import DITextures.AbstractSkin;
import DITextures.EnumSkinPart;
import DamageIndicatorsMod.DIMod;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class JarSkinRegistration
extends AbstractSkin {
    private static void checkEntry(JarEntry jEntry) {
        FMLLog.getLogger().info(jEntry.getName());
        if (jEntry.getName().contains("DITextures") && jEntry.getName().endsWith(".png")) {
            String thisSkin = jEntry.getName().substring(0, jEntry.getName().lastIndexOf("/"));
            if (!thisSkin.startsWith("/")) {
                thisSkin = "/" + thisSkin;
            }
            if (!thisSkin.endsWith("/")) {
                thisSkin = thisSkin + "/";
            }
            if (!AbstractSkin.AVAILABLESKINS.contains(thisSkin)) {
                AbstractSkin.AVAILABLESKINS.add(thisSkin);
            }
        }
    }

    private static void giveDebuggingInfo(Object test) {
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("======================================");
        FMLLog.getLogger().info("Java version/OS incompatibility detected!");
        FMLLog.getLogger().info("Please post this error block on the Minecraft Forum thread:");
        FMLLog.getLogger().info("http://www.minecraftforum.net/topic/1536685-151");
        FMLLog.getLogger().info("======================================");
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("--------------------------------------");
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("Connection method: " + String.valueOf(test));
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("Java version: " + System.getProperty("java.version"));
        FMLLog.getLogger().info("Java vendor: " + System.getProperty("java.vendor"));
        FMLLog.getLogger().info("Java url: " + System.getProperty("java.vendor.url"));
        FMLLog.getLogger().info("Java class version: " + System.getProperty("java.class.version"));
        FMLLog.getLogger().info("Java Architecture: " + System.getProperty("os.arch"));
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("Java Spec version: " + System.getProperty("java.specification.version"));
        FMLLog.getLogger().info("Java Spec vendor: " + System.getProperty("java.specification.vendor"));
        FMLLog.getLogger().info("Java Spec name: " + System.getProperty("java.specification.name"));
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("VM version: " + System.getProperty("java.vm.version"));
        FMLLog.getLogger().info("VM vendor: " + System.getProperty("java.vm.vendor"));
        FMLLog.getLogger().info("VM name: " + System.getProperty("java.vm.name"));
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("VM Spec version: " + System.getProperty("java.vm.specification.version"));
        FMLLog.getLogger().info("VM Spec vendor: " + System.getProperty("java.vm.specification.vendor"));
        FMLLog.getLogger().info("VM Spec name: " + System.getProperty("java.vm.specification.name"));
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("OS: " + System.getProperty("os.name"));
        FMLLog.getLogger().info("OS Version: " + System.getProperty("os.version"));
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("Spec version: " + System.getProperty("java.vm.specification.version"));
        FMLLog.getLogger().info("Spec vendor: " + System.getProperty("java.vm.specification.vendor"));
        FMLLog.getLogger().info("Spec name: " + System.getProperty("java.vm.specification.name"));
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info("--------------------------------------");
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info(" ");
        FMLLog.getLogger().info(" ");
    }

    public static void scanJarForSkins(Class clazz) {
        AbstractSkin.AVAILABLESKINS.add("/DITextures/Default/");
        AbstractSkin.AVAILABLESKINS.add("/DITextures/WoWLike/");
        AbstractSkin.AVAILABLESKINS.add("/DITextures/Minimal/");
        try {
            URL url = clazz.getResource("/DITextures");
            if (url != null) {
                URLConnection test = url.openConnection();
                if (test instanceof JarURLConnection) {
                    JarURLConnection juc = (JarURLConnection)test;
                    juc.setUseCaches(false);
                    juc.setDoInput(true);
                    juc.setDoOutput(false);
                    juc.setAllowUserInteraction(true);
                    juc.connect();
                    Enumeration<JarEntry> jEnum = juc.getJarFile().entries();
                    while (jEnum.hasMoreElements()) {
                        System.out.println(jEnum.nextElement());
                        try {
                            JarSkinRegistration.checkEntry(jEnum.nextElement());
                        }
                        catch (Exception ex) {}
                    }
                } else if (World.class.getName().endsWith("World")) {
                    FMLLog.getLogger().info("Damage Indicators detected deobfuscation.");
                } else {
                    JarSkinRegistration.giveDebuggingInfo(test);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JarSkinRegistration(String skinName) {
        this.setInternalName(skinName);
        this.setSkinValue(EnumSkinPart.FRAMENAME, skinName + "DIFrameSkin.png");
        this.setSkinValue(EnumSkinPart.TYPEICONSNAME, skinName + "DITypeIcons.png");
        this.setSkinValue(EnumSkinPart.DAMAGENAME, skinName + "damage.png");
        this.setSkinValue(EnumSkinPart.HEALTHNAME, skinName + "health.png");
        this.setSkinValue(EnumSkinPart.BACKGROUNDNAME, skinName + "background.png");
        this.setSkinValue(EnumSkinPart.NAMEPLATENAME, skinName + "NamePlate.png");
        this.setSkinValue(EnumSkinPart.LEFTPOTIONNAME, skinName + "leftPotions.png");
        this.setSkinValue(EnumSkinPart.RIGHTPOTIONNAME, skinName + "rightPotions.png");
        this.setSkinValue(EnumSkinPart.CENTERPOTIONNAME, skinName + "centerPotions.png");
        try {
            File file = File.createTempFile("skin", ".tmp");
            try {
                if (file.exists() && !file.delete()) {
                    file.deleteOnExit();
                    FMLLog.getLogger().info("Unable to delete old temp file:");
                    FMLLog.getLogger().info(file.getCanonicalPath());
                    file = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".skin.tmp");
                    FMLLog.getLogger().info("Creating unique temp file:");
                    FMLLog.getLogger().info(file.getCanonicalPath());
                }
                if (!file.createNewFile()) {
                    FMLLog.getLogger().info("Unable to create temp file:");
                    FMLLog.getLogger().info(file.getCanonicalPath());
                    FMLLog.getLogger().info("This may cause problems!");
                }
                URL url = Minecraft.class.getResource(skinName + "skin.cfg");
                InputStream cfg = url.openStream();
                FileOutputStream fos = new FileOutputStream(file);
                int bite = cfg.read();
                while (bite != -1) {
                    fos.write(bite);
                    bite = cfg.read();
                }
                fos.flush();
                fos.close();
                cfg.close();
            }
            catch (Exception ex) {
                FMLLog.severe((String)"Error reading skin config file!", (Object[])new Object[]{ex});
            }
            this.loadConfig(new Configuration(file));
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Exception ex) {
            FMLLog.severe((String)"Error reading skin config file!", (Object[])new Object[]{ex});
        }
    }

    private DynamicTexture checkAndReload(EnumSkinPart enumID, EnumSkinPart enumName) {
        DynamicTexture ret = (DynamicTexture)this.getSkinValue(enumID);
        if (ret == null) {
            try {
                String tmp = (String)this.getSkinValue(enumName);
                ret = this.setupTexture(JarSkinRegistration.fixDim(ImageIO.read(DIMod.class.getResourceAsStream(tmp))), enumID);
            }
            catch (Exception ex) {
                FMLLog.severe((String)"Error Loading Skin!", (Object[])new Object[]{ex});
            }
        }
        return ret;
    }

    @Override
    public final void loadSkin() {
        this.setSkinValue(EnumSkinPart.FRAMEID, this.checkAndReload(EnumSkinPart.FRAMEID, EnumSkinPart.FRAMENAME));
        this.setSkinValue(EnumSkinPart.TYPEICONSID, this.checkAndReload(EnumSkinPart.TYPEICONSID, EnumSkinPart.TYPEICONSNAME));
        this.setSkinValue(EnumSkinPart.DAMAGEID, this.checkAndReload(EnumSkinPart.DAMAGEID, EnumSkinPart.DAMAGENAME));
        this.setSkinValue(EnumSkinPart.HEALTHID, this.checkAndReload(EnumSkinPart.HEALTHID, EnumSkinPart.HEALTHNAME));
        this.setSkinValue(EnumSkinPart.BACKGROUNDID, this.checkAndReload(EnumSkinPart.BACKGROUNDID, EnumSkinPart.BACKGROUNDNAME));
        this.setSkinValue(EnumSkinPart.NAMEPLATEID, this.checkAndReload(EnumSkinPart.NAMEPLATEID, EnumSkinPart.NAMEPLATENAME));
        this.setSkinValue(EnumSkinPart.LEFTPOTIONID, this.checkAndReload(EnumSkinPart.LEFTPOTIONID, EnumSkinPart.LEFTPOTIONNAME));
        this.setSkinValue(EnumSkinPart.RIGHTPOTIONID, this.checkAndReload(EnumSkinPart.RIGHTPOTIONID, EnumSkinPart.RIGHTPOTIONNAME));
        this.setSkinValue(EnumSkinPart.CENTERPOTIONID, this.checkAndReload(EnumSkinPart.CENTERPOTIONID, EnumSkinPart.CENTERPOTIONNAME));
    }
}

